## Active Perl 5.8.8
# 注意>DBD-mysql を 4.005 以上にアップデートしてください。
# 注意>Jcode も必要です。
# 注意>やりかた: ppm install http://theoryx5.uwinnipeg.ca/ppms/DBD-mysql.ppd
# 注意>やりかた: ppm install Jcode

# *.htm 中のスキル名を一括して日本語化する
# GM 編

use utf8;
use strict;
use warnings;
use Encode;
use DBI;
use Jcode;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $vars_txt = 'tools/vars.txt';
open FILE,'<',$vars_txt  or do {warn "'$vars_txt' $!";exit 0};
read FILE,my $vars,-s FILE;
close FILE;
my $gsuser = ($vars =~ m/^\@*set gsuser=(.+)$/m)[0];
my $gspass = ($vars =~ m/^@*set gspass=(.+)$/m)[0];
my $gsdb   = ($vars =~ m/^@*set gsdb=(.+)$/m)[0];
my $gshost = ($vars =~ m/^@*set gshost=(.+)$/m)[0];

my $DEBUG = 0; # 1 or 0

my $LogFile = UTF8(__FILE__);
   $LogFile =~ s!\.[^.\/\\]*$!.log!;
open LOG, '>:utf8', FS($LogFile)  or die "'$LogFile' $!";

my $db = DBI->connect("DBI:mysql:$gsdb:$gshost", $gsuser, $gspass, {mysql_enable_utf8=>1}) or do{warn DBI::errstr;exit 0};
   $db->do('SET NAMES UTF8');

&start('build/dist/game/data/html/admin/skills/');

close LOG;
exit 0;

sub start {
	my ($subDir) = @_;

	opendir DIR, FS($subDir) or die "'$subDir' $!";
	my @files = readdir DIR;
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;

		my $filePath = $subDir.$fileName;

		if (-d FS($filePath)) {
			&start($filePath.'/');
			next;
		}

		next unless $fileName =~ m/\.html?$/;

		my $outPath = $filePath;
		   $outPath .= '.text' if $DEBUG;

		print "  $filePath\n" if $DEBUG;
		open FILE, '<:utf8', FS($filePath) or die "'$filePath' $!";
		my $mtime = (stat FILE)[9];
		read FILE,my $text,-s FILE;
		close FILE;

		my $original = $text;

		my $UPDATE = 0;

		# */X_xxxxx.htm
		# Special/Common_Skills.htm
		# Special/GM_Skills.htm
		while ($text =~ m!<td>([^"[<(]+?) \(max ([0-9]+)\)</td>\s*<td><button value="Add" action="bypass -h admin_add_skill ([0-9]+) \$level"!gs) {
			# <td>Anti Magic (max 45)</td><td><button value="Add" action="bypass -h admin_add_skill 146 $level" width=55 height=15 back="L2UI_ct1.button_df" fore="L2UI_ct1.button_df"></td>
			# --
			# <td>Wind Walk (max 1)</td>
			# <td><button value="Add" action="bypass -h admin_add_skill 7055 $level" width=55 height=15 back="L2UI_ct1.button_df" fore="L2UI_ct1.button_df"></td>

			my $name_en = $1;
			my $max     = $2;
			my $id      = $3;
			die unless $name_en;
			die unless $max;
			die unless $id;

			my $name_jp = &getName($id,undef);
			next unless $name_jp;
			next if $name_jp eq $name_en;

			$text =~ s!<td>[^"[<(]+?( \(max $max\)</td>\s*<td><button value="Add" action="bypass -h admin_add_skill $id \$level")!<\001td>$name_jp$1!s;

			my $i = &minidiff($text, $original) unless $UPDATE;
			print  '+',$outPath,"(",$i,")\n" unless $UPDATE;
			print     "\t[",$name_en,"]\n";
			print     "\t[",$name_jp,"]\n";
			print LOG  $outPath,"(",$i,")\n" unless $UPDATE;
			print LOG "\t[",$name_en,"]\n";
			print LOG "\t[",$name_jp,"]\n";

			$UPDATE = 1;
		}

		# Special/Clan_Skills.htm
		while ($text =~ m!<td>([^"[<(]+?)</td><td><a action="bypass -h admin_add_clan_skill (\d+) (\d+)">\d+</a></td>!gs) {
			# <td>Clan Vitality</td><td><a action="bypass -h admin_add_clan_skill 370 1">1</a></td><td><a action="bypass -h admin_add_clan_skill 370 2">2</a></td><td><a action="bypass -h admin_add_clan_skill 370 3">3</a></td>
			my $name_en = $1;
			my $id      = $2;
			my $level   = $3;
			die unless $name_en;
			die unless $id;
			die unless $level;

			my $name_jp = &getName($id,$level);
			next unless $name_jp;
			next if $name_jp eq $name_en;

			$text =~ s!<td>[^"[<(]+?</td>(<td><a action="bypass -h admin_add_clan_skill $id $level">\d+</a></td>)!<\001td>$name_jp</td>$1!s;

			my $i = &minidiff($text, $original) unless $UPDATE;
			print  '+',$outPath,"(",$i,")\n" unless $UPDATE;
			print     "\t[",$name_en,"]\n";
			print     "\t[",$name_jp,"]\n";
			print LOG  $outPath,"(",$i,")\n" unless $UPDATE;
			print LOG "\t[",$name_en,"]\n";
			print LOG "\t[",$name_jp,"]\n";

			$UPDATE = 1;
		}

		# E_TempleKnight4.htm
		while ($text =~ m!<a action="bypass -h admin_add_skill ([0-9]+) ([0-9]+)">([^"[<(]+?) \d+ \(Lv \d+\)</a>!gs) {
			# <a action="bypass -h admin_add_skill 67 1">Summon Life Cubic 1 (Lv 43)</a>
			my $id      = $1;
			my $level   = $2;
			my $name_en = $3;
			die unless $id;
			die unless $level;
			die unless $name_en;

			my $name_jp = &getName($id,$level);
			next unless $name_jp;
			next if $name_jp eq $name_en;

			$text =~ s!<a action=("bypass -h admin_add_skill $id $level">)[^"[<(]+?( \d+ \(Lv \d+\)</a>)!<\001a action=$1$name_jp$2!s;

			my $i = &minidiff($text, $original) unless $UPDATE;
			print  '+',$outPath,"(",$i,")\n" unless $UPDATE;
			print     "\t[",$name_en,"]\n";
			print     "\t[",$name_jp,"]\n";
			print LOG  $outPath,"(",$i,")\n" unless $UPDATE;
			print LOG "\t[",$name_en,"]\n";
			print LOG "\t[",$name_jp,"]\n";

			$UPDATE = 1;
		}

		# Special/Hero_Skills.htm
		# Special/Nobless_Skills.htm
		while ($text =~ m!<a action="bypass -h admin_add_skill ([0-9]+) ([0-9]+)">([^"[<(]+?)</a>!gs) {
			# <a action="bypass -h admin_add_skill 395 1">Heroic Miracle</a><br>
			my $id      = $1;
			my $level   = $2;
			my $name_en = $3;
			die unless $id;
			die unless $level;
			die unless $name_en;

			my $name_jp = &getName($id,$level);
			next unless $name_jp;
			next if $name_jp eq $name_en;

			$text =~ s!<a action=("bypass -h admin_add_skill $id $level">)[^"[<(]+?(</a>)!<\001a action=$1$name_jp$2!s;

			my $i = &minidiff($text, $original) unless $UPDATE;
			print  '+',$outPath,"(",$i,")\n" unless $UPDATE;
			print     "\t[",$name_en,"]\n";
			print     "\t[",$name_jp,"]\n";
			print LOG  $outPath,"(",$i,")\n" unless $UPDATE;
			print LOG "\t[",$name_en,"]\n";
			print LOG "\t[",$name_jp,"]\n";

			$UPDATE = 1;
		}

		$text =~ s/\001//g;

		if ($UPDATE) {
			open FILE, '>:utf8', FS($outPath) or die "'$outPath' $!";
			print FILE $text;
			close FILE;
			utime $mtime, $mtime, FS($outPath);
		}
	}
}

sub getName {
	my ($id,$level) = @_;

	my $sth;
	if ($level) {
		my $sql = "SELECT name FROM skillname_ja WHERE id=? AND level=?";
		$sth = $db->prepare($sql);
		$sth->execute($id,$level) or die DBI::errstr;
	} else {
		my $sql = "SELECT name FROM skillname_ja WHERE id=? LIMIT 0,1";
		$sth = $db->prepare($sql);
		$sth->execute($id) or die DBI::errstr;
	}

	$sth->bind_columns(undef, \(my($N_name))) or die DBI::errstr;
	my $rc = $sth->fetch();

	return '' unless $N_name;
	return Encode::decode_utf8(Jcode->new($N_name, 'utf8')->z2h->utf8)
#	return $N_name;
}

sub minidiff {
	my ($textA, $textB) = @_;

	$textA =~ s/^\x{FEFF}//;
	$textB =~ s/^\x{FEFF}//;
	my @A = split /\n/,$textA;
	my @B = split /\n/,$textB;
	my $min = $#A <= $#B ? $#A : $#B;
	for (my $i=0; $i <=$min; ++$i) {
		return $i+1 if $A[$i] ne $B[$i];
	}
	return 0;
}
