﻿<?php
mb_language('ja');
mb_internal_encoding('UTF-8');
require_once 'NET/SMTP.php';
/**
 * PEAR の NET/SMTP を使う方法
 *
 * 無料メールサーバを使用して SMTP 認証で送信します。
 * あらかじめ PEAR::Net_SMTP をインストールしておいてください。
 *  pear install -a Net_SMTP
 * （PHPをレンタルサーバで動かす場合は、業者に確認してください）
 *
 * 動作確認済メールサーバ：ポート
 *        smtp.mail.yahoo.co.jp:587
 *  ssl://smtp.mail.yahoo.co.jp:465  -注1
 *               smtp.gmail.com:587  -注1
 *         ssl://smtp.gmail.com:465  -注1
 *
 * -注1：php.ini の extension=php_openssl.dll を有効にしてください(「;」はずす)
 */

function sendmail($to, $subject, $body)
{
	///// あなたの環境にあわせて書き換えてください /////
	// ここから
	$myname = 'L2J スタッフ';
	$from = '**********@*****.com';
	$smtp_server = 'ssl://smtp.gmail.com';
	$smtp_port = 465;
	$smtp_auth_user = '**********@*****.com';
	$smtp_auth_passwd = '**********';
	$debug = FALSE;
	// ここまで
	////////////////////////////////////////////////////

	if (stristr($body, '<html>') == TRUE) $ContentType = 'text/html';
	else                                  $ContentType = 'text/plain';

	if ($debug) {echo '<pre>';}

	$smtp = new Net_SMTP($smtp_server, $smtp_port, 'l2jserver')
		or die('<br><b>Error</b>: Unable to instantiate Net_SMTP object in <b>'.basename(__FILE__).'</b> on line <b>'.__LINE__.'</b><br>');
	$smtp->setDebug($debug);

	if (PEAR::isError($e = $smtp->connect()))
		die('<br><b>Error</b>: '.$e->getMessage().' in <b>'.basename(__FILE__).'</b> on line <b>'.__LINE__.'</b><br>');

	if (PEAR::isError($e = $smtp->auth($smtp_auth_user, $smtp_auth_passwd)))
		die('<br><b>Error</b>: '.$e->getMessage().' in <b>'.basename(__FILE__).'</b> on line <b>'.__LINE__.'</b><br>');

	if (PEAR::isError($e = $smtp->mailFrom($from)))
		die('<br><b>Error</b>: '.$e->getMessage().' in <b>'.basename(__FILE__).'</b> on line <b>'.__LINE__.'</b><br>');

	if (PEAR::isError($e = $smtp->rcptTo($to)))
		die('<br><b>Error</b>: '.$e->getMessage().' in <b>'.basename(__FILE__).'</b> on line <b>'.__LINE__.'</b><br>');

	$data  = "From: ".mb_encode_mimeheader($myname)." <$from>\r\n";
	$data .= "To: $to\r\n";
	$data .= 'Subject: '.mb_encode_mimeheader($subject)."\r\n";
	$data .= "X-Mailer: L2J ACM/PHP/PEAR_Net_SMTP\r\n";
	$data .= "Content-Transfer-Encoding: 7bit\r\n";
	$data .= "Content-Type: $ContentType; charset=iso-2022-jp\r\n";
	$data .= "\r\n";
	$data .= mb_convert_encoding($body, 'iso-2022-jp', mb_internal_encoding());

	if (PEAR::isError($e = $smtp->data($data)))
		die('<br><b>Error</b>: '.$e->getMessage().' in <b>'.basename(__FILE__).'</b> on line <b>'.__LINE__.'</b><br>');

	$smtp->disconnect();
	if ($debug) {echo '</pre>';exit;}
	return TRUE;
}
/**
 * トラブルシューティング
 *
 * Error: STARTTLS failed
 *      php.ini の extension=php_openssl.dll を有効にしてください(「;」はずす)
 *
 * Error: Invalid response code received from server
 *      $debug = true; にしてレスポンスを見て判断してください。
 */
?>
