## Active Perl 5.8.8
use utf8;
use warnings;
use strict;
binmode STDOUT,'encoding(cp932)';

open CSV, '<:utf8', 'temp/itemname-j.txt'  or die $!;
my $mtime = (stat CSV)[9];

open SQL, '>:utf8', 'itemname_ja.sql'  or die $!;
print SQL "--
-- from 'itemname-j.dat'
--
DROP TABLE IF EXISTS itemname_ja;
CREATE TABLE itemname_ja (
	 id smallint(5) unsigned NOT NULL DEFAULT '0'
	,name varchar(120) NOT NULL DEFAULT ''
	,add_name varchar(120) NOT NULL DEFAULT ''
	,PRIMARY KEY (id)
) DEFAULT CHARSET=utf8;

";

my $count = 0;
my $delim = ' ';
<CSV>; # skip header
while (not eof CSV) {
	my $buf = <CSV>;
	chomp $buf;
	my @field = split /\t/, $buf;
	foreach (@field) {s/^[ua],//; s/\\0//}
	my ($id,$name,$add_name) = ($field[0],$field[1],$field[2]);
	$name =~ s/'/''/g;
	$add_name =~ s/'/''/g;
	print "$id\r";

	if (++$count > 500) {
		print SQL ";\n";
		$count = 1;
	}
	if ($count == 1) {
		print SQL "INSERT INTO itemname_ja (id,name,add_name) VALUES\n";
		$delim = ' ';
	}
	print SQL $delim,"($id,'$name','$add_name')\n";
	$delim = ',';
}
print SQL ";\n";
close SQL;
utime $mtime,$mtime,'itemname_ja.sql';

close CSV;
print "\n";
