/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package events.HeartPiece;

import static com.l2jserver.gameserver.util.EventNpcAligner.align;
import static com.l2jserver.gameserver.util.EventNpcAligner.getSpawns;

import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;

/**
 * n[g̔j Cxg
 * @author  2006/12/05 EvolutionIǗl@[GM] тɂ http://l2je.ath.cx
 * @author  2010/08/08 JOJO  5801_HeartPiece/__init__.py  java ɏ
 */
public class HeartPiece extends Quest
{
	private static final String qn = "HeartPiece";

	private static final int MANAGER = 31255;

	private static final int HEART1 = 4209;
	private static final int HEART2 = 4210;
	private static final int HEART3 = 4211;
	private static final int HEART4 = 4212;
	private static final int HEART5 = 4213;
	private static final int HEART6 = 4214;
	private static final int HEART7 = 4215;
	private static final int HEART8 = 4216;
	private static final int HEART9 = 4217;

	// Ƃ̏ܕi
	private static final int[][] ITEMS_WIN = {
		null,							// 0
		{ 955,2,  851,1,  882,1 },		// 1:  955 D-DAI | D|Dw
		{ 951,2,  854,1,  886,1 },		// 2:  951 C-DAI | ̎|w
		{ 947,2,  859,1,  117,1 },		// 3:  947 B-DAI | }i|w
		{ 729,2, 6324,1, 6325,1 },		// 4:  729 A-DAI | 󂳂ꂽtFjbNX|w
		{ 959,2, 6724,1, 6725,1 },		// 5:  959 S-DAI | 󂳂ꂽ^eIVA|w
	};

	// Ƃ̏ܕi
	private static final int[][] ITEMS_LOS = {
		{ 4625,1, 4626,1, 4627,1, 4628,1 },	// 0: 4625`4628 TCR
		{  956,1 },							// 1:  956 D-ZEL
		{  952,1 },							// 2:  952 C-ZEL
		{  948,1 },							// 3:  948 B-ZEL
		{  730,1 },							// 4:  730 A-ZEL
	/*	null,								// 5 */
	};

	private void giveRandomItems(QuestState st, int[] items)
	{
		int i = st.getRandom(items.length / 2) * 2;
		st.giveItems(/*item=*/items[i + 0], /*qty=*/items[i + 1]);
	}

	public HeartPiece(int questId, String name, String descr)
	{
		super(questId, name, descr);

		addStartNpc(MANAGER);
		addFirstTalkId(MANAGER);
		addTalkId(MANAGER);
		
		for (Location spawn : getSpawns())
			align(addSpawn(MANAGER, spawn, false, 0))
			.setTitle("n[gCxg");
	}
	private static final String[] PON_STR = { "O[", "`L", "p[" };
	private static final int EVEN = 999, WIN = 998, LOSS = 997;
	private static final int[/*player*/][/*npc*/] GAME_MATRIX = {
		{ EVEN, WIN,  LOSS },
		{ LOSS, EVEN, WIN  },
		{ WIN,  LOSS, EVEN },
	};

	@Override
	public String onEvent(String event, QuestState st)
	{
		String htmltext = event;
		
		int cond = st.getInt("cond");
		if (cond == 0) {
			if (event.equals("a")) {  // <main.htm>
				if (st.getQuestItemsCount(HEART1) > 0
				 && st.getQuestItemsCount(HEART2) > 0
				 && st.getQuestItemsCount(HEART3) > 0
				 && st.getQuestItemsCount(HEART4) > 0
				 && st.getQuestItemsCount(HEART5) > 0
				 && st.getQuestItemsCount(HEART6) > 0
				 && st.getQuestItemsCount(HEART7) > 0
				 && st.getQuestItemsCount(HEART8) > 0
				 && st.getQuestItemsCount(HEART9) > 0 ) {
					st.takeItems(HEART1,1);
					st.takeItems(HEART2,1);
					st.takeItems(HEART3,1);
					st.takeItems(HEART4,1);
					st.takeItems(HEART5,1);
					st.takeItems(HEART6,1);
					st.takeItems(HEART7,1);
					st.takeItems(HEART8,1);
					st.takeItems(HEART9,1);
					st.set("cond", "1");
					return "1-a.htm";
				} else {
					return "NG-a.htm";
				}
			} else if (event.equals("b")) {  // <main.htm>
				if (30 <= st.getQuestItemsCount(HEART1)
					    + st.getQuestItemsCount(HEART2)
					    + st.getQuestItemsCount(HEART3)
					    + st.getQuestItemsCount(HEART4)
					    + st.getQuestItemsCount(HEART5)
					    + st.getQuestItemsCount(HEART6)
					    + st.getQuestItemsCount(HEART7)
					    + st.getQuestItemsCount(HEART8)
					    + st.getQuestItemsCount(HEART9) ) {
					st.takeItems(HEART1, -1);
					st.takeItems(HEART2, -1);
					st.takeItems(HEART3, -1);
					st.takeItems(HEART4, -1);
					st.takeItems(HEART5, -1);
					st.takeItems(HEART6, -1);
					st.takeItems(HEART7, -1);
					st.takeItems(HEART8, -1);
					st.takeItems(HEART9, -1);
					st.set("cond", "1");
					return "1-b.htm";
				} else {
					return "NG-b.htm";
				}
			}
		} else if (event.equals("u") || event.equals("v") || event.equals("w")) {  // <123.htm> <even.htm>
			int iPlayer = "uvw".indexOf(event);	// u=0, v=1, w=2
			int iNpc = st.getRandom(3); // 0, 1, 2
			switch (GAME_MATRIX[iPlayer][iNpc]) {
			case EVEN:
				return resultHtmlText(st, "even.htm", iPlayer, iNpc);
			case WIN:
				++cond;
				st.set("cond", String.valueOf(cond));
				return resultHtmlText(st, String.valueOf(cond)+".htm", iPlayer, iNpc);	// 2.htm, 3.htm ... 6.htm
			case LOSS:
				giveRandomItems(st, ITEMS_LOS[cond - 1]);
				st.set("cond", "0");
				return resultHtmlText(st, "lose.htm", iPlayer, iNpc);
			}
		} else if (event.equals("end.htm")) {
			giveRandomItems(st, ITEMS_WIN[cond - 1]);
			st.set("cond", "0");
		} else if (!event.endsWith(".htm")) {
			throw new RuntimeException(event);
		}
		
		return htmltext;
	}
	private String resultHtmlText(QuestState st, String filename, int iPc, int iNpc)
	{
		return getHtm(st.getPlayer().getHtmlPrefix(), filename)
			.replace("%PLAYER%", PON_STR[iPc])
			.replace("%NPC%", PON_STR[iNpc]);
	}

	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
//		String htmltext = "";
		QuestState st = player.getQuestState(getName());
		if (st == null)
		{
			Quest q = QuestManager.getInstance().getQuest(getName());
			st = q.newQuestState(player);
		}
		switch (npc.getNpcId())
		{
			case MANAGER:
				int cond = st.getInt("cond");
				if (cond == 0)
					return "main.htm";
				else if (cond == 1)
					return "123.htm";
				else if (cond <= 6)
					return getHtm(st.getPlayer().getHtmlPrefix(), String.valueOf(cond)+".htm")
						.replace("%PLAYER%", "")
						.replace("%NPC%", "");
		}
		throw new RuntimeException();
	}

	public static void main(String[] args)
	{
		new HeartPiece(-1, qn, "events");
	}
}