/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.npc.NpcBuffers;

import java.util.concurrent.ScheduledFuture;

import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.effects.L2Effect;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.skills.L2SkillType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.util.Rnd;

//@formatter:off
/**
 * @author Drunkard, Zabb0x
 * 
 * @author JOJO
 * 
 * NPC          13006   NX}X c[  (type: L2Npc)
 * |ACe    5560    NX}X c[
 * |XL  2137-1  c[
 * 
 * NPC          13007   NX}X c[  (type: L2Npc)
 * |ACe    5561    NX}X c[
 * |XL  2138-1  c[
 * |BUFXL   2139-1  c[̉񕜃{[iX - NX}X Cxg̍c[ʁBHP񕜃{[iXAMP񕜃{[iXサԁB
 */
public class ChristmasTree extends AbstractNpcAI
{
	private static final int SPECIAL_CHRISTMAS_TREE = 13007;
	
	static final L2Skill RECOVERY_BONUS = SkillTable.getInstance().getInfo(2139, 1);	// c[̉񕜃{[iX
	
	static final L2Skill[] SUPPORT_MAGICS = {
		SkillTable.getInstance().getInfo(4262, 2),	// NX}X EBh EH[N^莞ԁAړxサԁB2B
		SkillTable.getInstance().getInfo(4263, 1),	// NX}X wCXg^ꎞIɍUxコB1B
		SkillTable.getInstance().getInfo(4264, 1),	// NX}X Gp[^ꎞIɖ͂サԁB1B
		SkillTable.getInstance().getInfo(4265, 3),	// NX}X }Cg^ꎞIɍU͂サԁB3B
		SkillTable.getInstance().getInfo(4266, 3),	// NX}X V[h^ꎞIɖh͂サԁB3B
	};
	
	private static final String[] XMASS_SONGS = {
		"CC_01", "CC_02", "CC_03", "CC_04", "CC_05", "CC_06"
	};
	
	protected ChristmasTree(String name, String descr)
	{
		super(name, descr);
		addFirstTalkId(SPECIAL_CHRISTMAS_TREE);
		addSpawnId(SPECIAL_CHRISTMAS_TREE);
		if (RECOVERY_BONUS.getSkillType() == L2SkillType.NOTDONE) throw new RuntimeException();
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		return null;
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		if (npc.isInsideZone(ZoneId.PEACE)) return null;
		new ChristmasTreeAI(npc);
		npc.broadcastPacket(new PlaySound(XMASS_SONGS[Rnd.get(XMASS_SONGS.length)]));
		return null;
	}
	
	protected class ChristmasTreeAI implements Runnable
	{
		private final L2Npc _npc;
		private int _index = 0;
		private final ScheduledFuture<?> _aiTask;
		
		protected ChristmasTreeAI(L2Npc npc)
		{
			_npc = npc;
			_aiTask = ThreadPoolManager.getInstance().scheduleGeneralWithFixedDelay(this, 3000, 3000);
		}
		
		@Override
		public void run()
		{
			if (!_npc.isVisible())
			{
				_aiTask.cancel(false);
				return;
			}
			
			final int skillRadius = RECOVERY_BONUS.getSkillRadius();
			for (L2PcInstance player : _npc.getKnownList().getKnownPlayers().values())
			{
				if (player.isInvul())
					continue;
				if (player.isMovementDisabled())
					continue;
				if (player.getPkKills() > 5)
					continue;
				if (!player.isInsideRadius(_npc, skillRadius, true, true))
					continue;
				if (player.getCurrentHp() < player.getMaxHp()
				 || player.getCurrentMp() < player.getMaxMp())
				{
					handleEffect(player, RECOVERY_BONUS);
				}
				else
				{
					handleBuff(player, SUPPORT_MAGICS[_index]);
				}
			}
			_index = (_index + 1) % SUPPORT_MAGICS.length;
		}
		
		protected void handleEffect(L2PcInstance player, L2Skill skill)
		{
			if (! doesStack(player, skill))
				skill.getEffects(player, player);
		}
		
		protected void handleBuff(L2PcInstance player, L2Skill skill)
		{
			if (! doesStack(player, skill))
			{
				skill.getEffects(_npc, player);
				player.sendPacket(new MagicSkillUse(_npc, player, skill.getId(), skill.getLevel(), skill.getHitTime(), 0));
			}
		}
		
		private boolean doesStack(L2PcInstance player, L2Skill checkSkill)
		{
			String stackType = checkSkill.getEffectTemplates()[0].abnormalType;
			for (L2Effect e : player.getAllEffects())
				if (stackType.equals(e.getAbnormalType()))
					return true;
			return false;
		}
	}
	
	public static void main(String[] args)
	{
		new ChristmasTree("ai/npc/ChristmasTree", "");	//+[JOJO] scripts/events/ChristmasTree/ChristmasTree.java  qn="ChristmasTree" ƏՓ˂̂.
	//	new ChristmasTree(ChristmasTree.class.getSimpleName(), "ai/npc");	//-[JOJO]
	}
}
