## o Active Perl 5.8.8
## o Active Perl 5.14.2
## x Active Perl 5.16.0
## x Active Perl 5.16.1

use utf8;
use warnings;
use strict;
use Encode;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $DEBUG = 0; # 1 or 0

my $LogFile = UTF8(__FILE__);
   $LogFile =~ s!\.[^.\/\\]*$!.log!;
open LOG, '>:utf8', FS($LogFile) or die "'$LogFile' $!";

&start('build/dist/');

close LOG;
exit 0;

sub start {
	my ($subDir) = @_;

	print ' [',$subDir,"]\n";
	opendir DIR, FS($subDir) or die "'$subDir' $!";
	my @files = readdir DIR; $_ = UTF8($_) foreach (@files);
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;
		my $filePath = $subDir.$fileName;
		my $outPath = $filePath;
		   $outPath .= '.text' if $DEBUG;

		if (-d FS($filePath)) {
			$filePath =~ s!^\.\/!!;
			&start($filePath.'/');
			next;
		}

		my $encode;
		if    ($fileName =~ /\.java$/)  {$encode = ':encoding(cp932)'}
		elsif ($fileName =~ /\.py$/)    {$encode = ':encoding(cp932)'}
		else {next}

		print "  $filePath\n" if $DEBUG;
		open FILE, '<'.$encode, FS($filePath) or die "'$filePath' $!";
		read FILE,my $text,-s FILE;
		my $mtime = (stat FILE)[9];
		close FILE;

		my $original = $text;
		$_           = $text;

#------------------------------------------------------------------------------

# Quest.java rev 5677 の public static enum QuestSound から作成.

	s{(?<=\.playSound\()"ItemSound\.quest_accept"(?=\))}                  {QuestSound.ITEMSOUND_QUEST_ACCEPT}gi;
	s{(?<=\.playSound\()"ItemSound\.quest_middle"(?=\))}                  {QuestSound.ITEMSOUND_QUEST_MIDDLE}gi;
	s{(?<=\.playSound\()"ItemSound\.quest_finish"(?=\))}                  {QuestSound.ITEMSOUND_QUEST_FINISH}gi;
	s{(?<=\.playSound\()"ItemSound\.quest_itemget"(?=\))}                 {QuestSound.ITEMSOUND_QUEST_ITEMGET}gi;
	# Newbie Guide tutorial (incl. some quests), Mutated Kaneus quests, Quest 192
	s{(?<=\.playSound\()"ItemSound\.quest_tutorial"(?=\))}                {QuestSound.ITEMSOUND_QUEST_TUTORIAL}gi;
	# Quests 107, 363, 364
	s{(?<=\.playSound\()"ItemSound\.quest_giveup"(?=\))}                  {QuestSound.ITEMSOUND_QUEST_GIVEUP}gi;
	# Quests 212, 217, 224, 226, 416
	s{(?<=\.playSound\()"ItemSound\.quest_before_battle"(?=\))}           {QuestSound.ITEMSOUND_QUEST_BEFORE_BATTLE}gi;
	# Quests 211, 258, 266, 330
	s{(?<=\.playSound\()"ItemSound\.quest_jackpot"(?=\))}                 {QuestSound.ITEMSOUND_QUEST_JACKPOT}gi;
	# Quests 508, 509 and 510
	s{(?<=\.playSound\()"ItemSound\.quest_fanfare_1"(?=\))}               {QuestSound.ITEMSOUND_QUEST_FANFARE_1}gi;
	# played ONLY after class transfer via Test Server Helpers (Id 31756 and 31757)
	s{(?<=\.playSound\()"ItemSound\.quest_fanfare_2"(?=\))}               {QuestSound.ITEMSOUND_QUEST_FANFARE_2}gi;
	# Quest 114
	s{(?<=\.playSound\()"ItemSound\.armor_wood_3"(?=\))}                  {QuestSound.ITEMSOUND_ARMOR_WOOD}gi;
	# Quest 21
	s{(?<=\.playSound\()"ItemSound\.item_drop_equip_armor_cloth"(?=\))}   {QuestSound.ITEMSOUND_ARMOR_CLOTH}gi;
	s{(?<=\.playSound\()"AmdSound\.ed_chimes_05"(?=\))}                   {QuestSound.ITEMSOUND_ED_CHIMES}gi;
	# Quest 23
	s{(?<=\.playSound\()"ItemSound\.itemdrop_armor_leather"(?=\))}        {QuestSound.ITEMSOUND_ARMOR_LEATHER}gi;
	s{(?<=\.playSound\()"ItemSound\.itemdrop_weapon_spear"(?=\))}         {QuestSound.ITEMSOUND_WEAPON_SPEAR}gi;
	# Quest 24
	s{(?<=\.playSound\()"AmdSound\.d_wind_loot_02"(?=\))}                 {QuestSound.AMDSOUND_D_WIND_LOOT_02}gi;
	s{(?<=\.playSound\()"InterfaceSound.charstat_open_01"(?=\))}          {QuestSound.INTERFACESOUND_CHARSTAT_OPEN_01}gi;
	# Quest 648 and treasure chests
	s{(?<=\.playSound\()"ItemSound2\.broken_key"(?=\))}                   {QuestSound.ITEMSOUND_BROKEN_KEY}gi;
	# Quest 184
	s{(?<=\.playSound\()"ItemSound3\.sys_siren"(?=\))}                    {QuestSound.ITEMSOUND_SIREN}gi;
	# Quest 648
	s{(?<=\.playSound\()"ItemSound3\.sys_enchant_success"(?=\))}          {QuestSound.ITEMSOUND_ENCHANT_SUCCESS}gi;
	s{(?<=\.playSound\()"ItemSound3\.sys_enchant_failed"(?=\))}           {QuestSound.ITEMSOUND_ENCHANT_FAILED}gi;
	# Best farm mobs
	s{(?<=\.playSound\()"ItemSound3\.sys_sow_success"(?=\))}              {QuestSound.ITEMSOUND_SOW_SUCCESS}gi;
	# Quest 25
	s{(?<=\.playSound\()"SkillSound5\.horror_01"(?=\))}                   {QuestSound.SKILLSOUND_HORROR_1}gi;
	# Quests 21 and 23
	s{(?<=\.playSound\()"SkillSound5\.horror_02"(?=\))}                   {QuestSound.SKILLSOUND_HORROR_2}gi;
	# Quest 22
	s{(?<=\.playSound\()"SkillSound3\.antaras_fear"(?=\))}                {QuestSound.SKILLSOUND_ANTARAS_FEAR}gi;
	# Quest 505
	s{(?<=\.playSound\()"SkillSound2\.jewel.celebrate"(?=\))}             {QuestSound.SKILLSOUND_JEWEL_CELEBRATE}gi;
	# Quest 373
	s{(?<=\.playSound\()"SkillSound5\.liquid_mix_01"(?=\))}               {QuestSound.SKILLSOUND_LIQUID_MIX}gi;
	s{(?<=\.playSound\()"SkillSound5\.liquid_success_01"(?=\))}           {QuestSound.SKILLSOUND_LIQUID_SUCCESS}gi;
	s{(?<=\.playSound\()"SkillSound5\.liquid_fail_01"(?=\))}              {QuestSound.SKILLSOUND_LIQUID_FAIL}gi;
	# Elroki sounds - Quest 111
	s{(?<=\.playSound\()"EtcSound\.elcroki_song_full"(?=\))}              {QuestSound.ETCSOUND_ELROKI_SOUND_FULL}gi;
	s{(?<=\.playSound\()"EtcSound\.elcroki_song_1st"(?=\))}               {QuestSound.ETCSOUND_ELROKI_SOUND_1ST}gi;
	s{(?<=\.playSound\()"EtcSound\.elcroki_song_2nd"(?=\))}               {QuestSound.ETCSOUND_ELROKI_SOUND_2ND}gi;
	s{(?<=\.playSound\()"EtcSound\.elcroki_song_3rd"(?=\))}               {QuestSound.ETCSOUND_ELROKI_SOUND_3RD}gi;
	# PailakaInjuredDragon
	s{(?<=\.playSound\()"BS08_A"(?=\))}                                   {QuestSound.BS08_A}gi;


	if (m/QuestSound\./) {
		if ($fileName =~ /\.java$/)  {
			unless (m/^import com.l2jserver.gameserver.model.quest.Quest.QuestSound;/m
			     || m/^import com.l2jserver.gameserver.model.quest.Quest;/m
			     || m/^import com.l2jserver.gameserver.model.quest.jython.QuestJython;/m
			     || m/^import ai.npc.AbstractNpcAI;/m) {
				s/\bQuestSound\./com.l2jserver.gameserver.model.quest.Quest.QuestSound./g;
			}
		}
		elsif ($fileName =~ /\.py$/) {
			unless (m/from com.l2jserver.gameserver.model.quest.Quest[ \t]+import QuestSound/) {
				   s/(?<=import QuestJython as JQuest)/\nfrom com.l2jserver.gameserver.model.quest.Quest import QuestSound/s
				&& s/\n\n/\n/s;
			}
		}
	}

#------------------------------------------------------------------------------

		$text = $_;
		next if $text eq $original;

		open FILE, '>'.$encode, FS($outPath) or die "'$outPath' $!";
		print FILE $text;
		close FILE;
		utime $mtime, $mtime, FS($outPath);

		my $i = &minidiff($text, $original);
		print       "+$outPath($i)\n";
		print LOG "../$outPath($i)\n";
	}
}

sub minidiff {
	my ($textA, $textB) = @_;

	$textA =~ s/^\x{FEFF}//;
	$textB =~ s/^\x{FEFF}//;
	my @A = split /\n/,$textA;
	my @B = split /\n/,$textB;
	my $min = $#A <= $#B ? $#A : $#B;
	for (my $i=0; $i <=$min; ++$i) {
		return $i+1 if $A[$i] ne $B[$i];
	}
	return 0;
}
