/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.util.Hashtable;
import org.python.core.ArgParser;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyFunction;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyMethod;
import org.python.core.PyModule;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.__builtin__;
import org.python.core.codecs;
import org.python.core.imp;
import org.python.modules.cStringIO;

public class cPickle
implements ClassDictInit {
    public static String __doc__ = "Java implementation and optimization of the Python pickle module\n\n$Id: cPickle.java 2945 2006-09-23 19:35:44Z cgroves $\n";
    public static String __version__ = "1.30";
    public static final String format_version = "1.3";
    public static final String[] compatible_formats = new String[]{"1.0", "1.1", "1.2"};
    public static String[] __depends__ = new String[]{"copy_reg"};
    public static PyObject PickleError;
    public static PyObject PicklingError;
    public static PyObject UnpickleableError;
    public static PyObject UnpicklingError;
    public static final PyString BadPickleGet;
    static final char MARK = '(';
    static final char STOP = '.';
    static final char POP = '0';
    static final char POP_MARK = '1';
    static final char DUP = '2';
    static final char FLOAT = 'F';
    static final char INT = 'I';
    static final char BININT = 'J';
    static final char BININT1 = 'K';
    static final char LONG = 'L';
    static final char BININT2 = 'M';
    static final char NONE = 'N';
    static final char PERSID = 'P';
    static final char BINPERSID = 'Q';
    static final char REDUCE = 'R';
    static final char STRING = 'S';
    static final char BINSTRING = 'T';
    static final char SHORT_BINSTRING = 'U';
    static final char UNICODE = 'V';
    static final char BINUNICODE = 'X';
    static final char APPEND = 'a';
    static final char BUILD = 'b';
    static final char GLOBAL = 'c';
    static final char DICT = 'd';
    static final char EMPTY_DICT = '}';
    static final char APPENDS = 'e';
    static final char GET = 'g';
    static final char BINGET = 'h';
    static final char INST = 'i';
    static final char LONG_BINGET = 'j';
    static final char LIST = 'l';
    static final char EMPTY_LIST = ']';
    static final char OBJ = 'o';
    static final char PUT = 'p';
    static final char BINPUT = 'q';
    static final char LONG_BINPUT = 'r';
    static final char SETITEM = 's';
    static final char TUPLE = 't';
    static final char EMPTY_TUPLE = ')';
    static final char SETITEMS = 'u';
    static final char BINFLOAT = 'G';
    private static PyDictionary dispatch_table;
    private static PyDictionary safe_constructors;
    private static PyType BuiltinFunctionType;
    private static PyType BuiltinMethodType;
    private static PyType ClassType;
    private static PyType TypeType;
    private static PyType DictionaryType;
    private static PyType StringMapType;
    private static PyType FloatType;
    private static PyType FunctionType;
    private static PyType InstanceType;
    private static PyType IntType;
    private static PyType ListType;
    private static PyType LongType;
    private static PyType NoneType;
    private static PyType StringType;
    private static PyType TupleType;
    private static PyType FileType;
    private static PyObject dict;
    private static Hashtable classmap;
    static /* synthetic */ Class class$java$lang$Object;

    public static void classDictInit(PyObject pyObject) {
        dict = pyObject;
        imp.importName("__builtin__", true);
        PyModule pyModule = (PyModule)cPickle.importModule("copy_reg");
        dispatch_table = (PyDictionary)pyModule.__getattr__("dispatch_table");
        safe_constructors = (PyDictionary)pyModule.__getattr__("safe_constructors");
        PickleError = cPickle.buildClass("PickleError", Py.Exception, "_PickleError", "");
        PicklingError = cPickle.buildClass("PicklingError", PickleError, "_empty__init__", "");
        UnpickleableError = cPickle.buildClass("UnpickleableError", PicklingError, "_UnpickleableError", "");
        UnpicklingError = cPickle.buildClass("UnpicklingError", PickleError, "_empty__init__", "");
    }

    public static PyObject _empty__init__(PyObject[] pyObjectArray, String[] stringArray) {
        PyStringMap pyStringMap = new PyStringMap();
        ((PyObject)pyStringMap).__setitem__("__module__", (PyObject)new PyString("cPickle"));
        return pyStringMap;
    }

    public static PyObject _PickleError(PyObject[] pyObjectArray, String[] stringArray) {
        PyObject pyObject = cPickle._empty__init__(pyObjectArray, stringArray);
        pyObject.__setitem__("__init__", cPickle.getJavaFunc("_PickleError__init__"));
        pyObject.__setitem__("__str__", cPickle.getJavaFunc("_PickleError__str__"));
        return pyObject;
    }

    public static void _PickleError__init__(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("__init__", pyObjectArray, stringArray, "self", "args");
        PyObject pyObject = argParser.getPyObject(0);
        PyObject pyObject2 = argParser.getList(1);
        pyObject.__setattr__("args", pyObject2);
    }

    public static PyString _PickleError__str__(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("__str__", pyObjectArray, stringArray, "self");
        PyObject pyObject = argParser.getPyObject(0);
        PyObject pyObject2 = pyObject.__getattr__("args");
        if (pyObject2.__len__() > 0 && pyObject2.__getitem__(0).__len__() > 0) {
            return pyObject2.__getitem__(0).__str__();
        }
        return new PyString("(what)");
    }

    public static PyObject _UnpickleableError(PyObject[] pyObjectArray, String[] stringArray) {
        PyObject pyObject = cPickle._empty__init__(pyObjectArray, stringArray);
        pyObject.__setitem__("__init__", cPickle.getJavaFunc("_UnpickleableError__init__"));
        pyObject.__setitem__("__str__", cPickle.getJavaFunc("_UnpickleableError__str__"));
        return pyObject;
    }

    public static void _UnpickleableError__init__(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("__init__", pyObjectArray, stringArray, "self", "args");
        PyObject pyObject = argParser.getPyObject(0);
        PyObject pyObject2 = argParser.getList(1);
        pyObject.__setattr__("args", pyObject2);
    }

    public static PyString _UnpickleableError__str__(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("__str__", pyObjectArray, stringArray, "self");
        PyObject pyObject = argParser.getPyObject(0);
        PyObject pyObject2 = pyObject.__getattr__("args");
        PyObject pyObject3 = pyObject2.__len__() > 0 ? pyObject2.__getitem__(0) : new PyString("(what)");
        return new PyString("Cannot pickle %s objects").__mod__(pyObject3).__str__();
    }

    public static Pickler Pickler(PyObject pyObject) {
        return new Pickler(pyObject, false);
    }

    public static Pickler Pickler(PyObject pyObject, boolean bl) {
        return new Pickler(pyObject, bl);
    }

    public static Unpickler Unpickler(PyObject pyObject) {
        return new Unpickler(pyObject);
    }

    public static void dump(PyObject pyObject, PyObject pyObject2) {
        cPickle.dump(pyObject, pyObject2, false);
    }

    public static void dump(PyObject pyObject, PyObject pyObject2, boolean bl) {
        new Pickler(pyObject2, bl).dump(pyObject);
    }

    public static String dumps(PyObject pyObject) {
        return cPickle.dumps(pyObject, false);
    }

    public static String dumps(PyObject pyObject, boolean bl) {
        cStringIO.StringIO stringIO = cStringIO.StringIO();
        cPickle.dump(pyObject, stringIO, bl);
        return stringIO.getvalue();
    }

    public static Object load(PyObject pyObject) {
        return new Unpickler(pyObject).load();
    }

    public static Object loads(PyObject pyObject) {
        cStringIO.StringIO stringIO = cStringIO.StringIO(pyObject.toString());
        return new Unpickler(stringIO).load();
    }

    private static IOFile createIOFile(PyObject pyObject) {
        Object object = pyObject.__tojava__(cStringIO.StringIO.class);
        if (object != Py.NoConversion) {
            return new cStringIOFile((cStringIO.StringIO)pyObject);
        }
        if (__builtin__.isinstance(pyObject, FileType)) {
            return new FileIOFile(pyObject);
        }
        return new ObjectIOFile(pyObject);
    }

    private static final PyObject whichmodule(PyObject pyObject, PyObject pyObject2) {
        PyObject pyObject3 = (PyObject)classmap.get(pyObject);
        if (pyObject3 != null) {
            return pyObject3;
        }
        pyObject3 = new PyString("__main__");
        PyObject pyObject4 = imp.importName("sys", true);
        PyObject pyObject5 = pyObject4.__findattr__("modules");
        PyObject pyObject6 = pyObject5.invoke("keys");
        int n = pyObject6.__len__();
        for (int i = 0; i < n; ++i) {
            PyObject pyObject7 = pyObject6.__finditem__(i);
            PyObject pyObject8 = pyObject5.__finditem__(pyObject7);
            if (pyObject7.equals("__main__") || pyObject8.__findattr__(pyObject2.toString().intern()) != pyObject) continue;
            pyObject3 = pyObject7;
            break;
        }
        classmap.put(pyObject, pyObject3);
        return pyObject3;
    }

    private static PyObject importModule(String string) {
        PyTuple pyTuple = new PyTuple(new PyString[]{Py.newString("__doc__")});
        return __builtin__.__import__(string, null, null, pyTuple);
    }

    private static PyObject getJavaFunc(String string) {
        return Py.newJavaFunc(cPickle.class, string);
    }

    private static PyObject buildClass(String string, PyObject pyObject, String string2, String string3) {
        PyObject[] pyObjectArray = Py.EmptyObjects;
        if (pyObject != null) {
            pyObjectArray = new PyObject[]{pyObject};
        }
        PyObject pyObject2 = Py.makeClass(string, pyObjectArray, Py.newJavaCode(cPickle.class, string2), new PyString(string3));
        return pyObject2;
    }

    static {
        BadPickleGet = new PyString("cPickle.BadPickleGet");
        dispatch_table = null;
        safe_constructors = null;
        BuiltinFunctionType = PyType.fromClass(PyReflectedFunction.class);
        BuiltinMethodType = PyType.fromClass(PyMethod.class);
        ClassType = PyType.fromClass(PyClass.class);
        TypeType = PyType.fromClass(PyType.class);
        DictionaryType = PyType.fromClass(PyDictionary.class);
        StringMapType = PyType.fromClass(PyStringMap.class);
        FloatType = PyType.fromClass(PyFloat.class);
        FunctionType = PyType.fromClass(PyFunction.class);
        InstanceType = PyType.fromClass(PyInstance.class);
        IntType = PyType.fromClass(PyInteger.class);
        ListType = PyType.fromClass(PyList.class);
        LongType = PyType.fromClass(PyLong.class);
        NoneType = PyType.fromClass(PyNone.class);
        StringType = PyType.fromClass(PyString.class);
        TupleType = PyType.fromClass(PyTuple.class);
        FileType = PyType.fromClass(PyFile.class);
        classmap = new Hashtable();
    }

    public static class Unpickler {
        private IOFile file;
        public Hashtable memo = new Hashtable();
        public PyObject persistent_load = null;
        private PyObject mark = new PyString("spam");
        private int stackTop;
        private PyObject[] stack;

        Unpickler(PyObject pyObject) {
            this.file = cPickle.createIOFile(pyObject);
        }

        public PyObject load() {
            this.stackTop = 0;
            this.stack = new PyObject[10];
            while (true) {
                String string;
                if ((string = this.file.read(1)).length() < 1) {
                    this.load_eof();
                }
                char c = string.charAt(0);
                switch (c) {
                    case 'P': {
                        this.load_persid();
                        break;
                    }
                    case 'Q': {
                        this.load_binpersid();
                        break;
                    }
                    case 'N': {
                        this.load_none();
                        break;
                    }
                    case 'I': {
                        this.load_int();
                        break;
                    }
                    case 'J': {
                        this.load_binint();
                        break;
                    }
                    case 'K': {
                        this.load_binint1();
                        break;
                    }
                    case 'M': {
                        this.load_binint2();
                        break;
                    }
                    case 'L': {
                        this.load_long();
                        break;
                    }
                    case 'F': {
                        this.load_float();
                        break;
                    }
                    case 'G': {
                        this.load_binfloat();
                        break;
                    }
                    case 'S': {
                        this.load_string();
                        break;
                    }
                    case 'T': {
                        this.load_binstring();
                        break;
                    }
                    case 'U': {
                        this.load_short_binstring();
                        break;
                    }
                    case 'V': {
                        this.load_unicode();
                        break;
                    }
                    case 'X': {
                        this.load_binunicode();
                        break;
                    }
                    case 't': {
                        this.load_tuple();
                        break;
                    }
                    case ')': {
                        this.load_empty_tuple();
                        break;
                    }
                    case ']': {
                        this.load_empty_list();
                        break;
                    }
                    case '}': {
                        this.load_empty_dictionary();
                        break;
                    }
                    case 'l': {
                        this.load_list();
                        break;
                    }
                    case 'd': {
                        this.load_dict();
                        break;
                    }
                    case 'i': {
                        this.load_inst();
                        break;
                    }
                    case 'o': {
                        this.load_obj();
                        break;
                    }
                    case 'c': {
                        this.load_global();
                        break;
                    }
                    case 'R': {
                        this.load_reduce();
                        break;
                    }
                    case '0': {
                        this.load_pop();
                        break;
                    }
                    case '1': {
                        this.load_pop_mark();
                        break;
                    }
                    case '2': {
                        this.load_dup();
                        break;
                    }
                    case 'g': {
                        this.load_get();
                        break;
                    }
                    case 'h': {
                        this.load_binget();
                        break;
                    }
                    case 'j': {
                        this.load_long_binget();
                        break;
                    }
                    case 'p': {
                        this.load_put();
                        break;
                    }
                    case 'q': {
                        this.load_binput();
                        break;
                    }
                    case 'r': {
                        this.load_long_binput();
                        break;
                    }
                    case 'a': {
                        this.load_append();
                        break;
                    }
                    case 'e': {
                        this.load_appends();
                        break;
                    }
                    case 's': {
                        this.load_setitem();
                        break;
                    }
                    case 'u': {
                        this.load_setitems();
                        break;
                    }
                    case 'b': {
                        this.load_build();
                        break;
                    }
                    case '(': {
                        this.load_mark();
                        break;
                    }
                    case '.': {
                        return this.load_stop();
                    }
                }
            }
        }

        private final int marker() {
            for (int i = this.stackTop - 1; i >= 0; --i) {
                if (this.stack[i] != this.mark) continue;
                return this.stackTop - i - 1;
            }
            throw new PyException(UnpicklingError, "Inputstream corrupt, marker not found");
        }

        private final void load_eof() {
            throw new PyException(Py.EOFError);
        }

        private final void load_persid() {
            String string = this.file.readlineNoNl();
            this.push(this.persistent_load.__call__(new PyString(string)));
        }

        private final void load_binpersid() {
            PyObject pyObject = this.pop();
            this.push(this.persistent_load.__call__(pyObject));
        }

        private final void load_none() {
            this.push(Py.None);
        }

        private final void load_int() {
            PyObject pyObject;
            String string = this.file.readlineNoNl();
            try {
                pyObject = Py.newInteger(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    pyObject = Py.newLong(string);
                }
                catch (NumberFormatException numberFormatException2) {
                    throw Py.ValueError("could not convert string to int");
                }
            }
            this.push(pyObject);
        }

        private final void load_binint() {
            String string = this.file.read(4);
            int n = string.charAt(0) | string.charAt(1) << 8 | string.charAt(2) << 16 | string.charAt(3) << 24;
            this.push(new PyInteger(n));
        }

        private final void load_binint1() {
            char c = this.file.read(1).charAt(0);
            this.push(new PyInteger(c));
        }

        private final void load_binint2() {
            String string = this.file.read(2);
            int n = string.charAt(1) << 8 | string.charAt(0);
            this.push(new PyInteger(n));
        }

        private final void load_long() {
            String string = this.file.readlineNoNl();
            this.push(new PyLong(string.substring(0, string.length() - 1)));
        }

        private final void load_float() {
            String string = this.file.readlineNoNl();
            this.push(new PyFloat(Double.valueOf(string)));
        }

        private final void load_binfloat() {
            String string = this.file.read(8);
            long l = (long)string.charAt(7) | (long)string.charAt(6) << 8 | (long)string.charAt(5) << 16 | (long)string.charAt(4) << 24 | (long)string.charAt(3) << 32 | (long)string.charAt(2) << 40 | (long)string.charAt(1) << 48 | (long)string.charAt(0) << 56;
            this.push(new PyFloat(Double.longBitsToDouble(l)));
        }

        private final void load_string() {
            int n;
            String string = this.file.readlineNoNl();
            char c = string.charAt(0);
            if (c != '\"' && c != '\'') {
                throw Py.ValueError("insecure string pickle");
            }
            int n2 = 0;
            char c2 = '\u0000';
            int n3 = string.length();
            for (n = 1; n < n3 && ((c2 = string.charAt(n)) != c || n2 % 2 != 0); ++n) {
                if (c2 == '\\') {
                    ++n2;
                    continue;
                }
                n2 = 0;
            }
            if (c2 != c) {
                throw Py.ValueError("insecure string pickle");
            }
            ++n;
            while (n < string.length()) {
                if (string.charAt(n) > ' ') {
                    throw Py.ValueError("insecure string pickle " + n);
                }
                ++n;
            }
            String string2 = PyString.decode_UnicodeEscape(string, 1, n3 - 1, "strict", false);
            this.push(new PyString(string2));
        }

        private final void load_binstring() {
            String string = this.file.read(4);
            int n = string.charAt(0) | string.charAt(1) << 8 | string.charAt(2) << 16 | string.charAt(3) << 24;
            this.push(new PyString(this.file.read(n)));
        }

        private final void load_short_binstring() {
            char c = this.file.read(1).charAt(0);
            this.push(new PyString(this.file.read(c)));
        }

        private final void load_unicode() {
            String string = this.file.readlineNoNl();
            int n = string.length();
            String string2 = codecs.PyUnicode_DecodeRawUnicodeEscape(string, "strict");
            this.push(new PyString(string2));
        }

        private final void load_binunicode() {
            String string = this.file.read(4);
            int n = string.charAt(0) | string.charAt(1) << 8 | string.charAt(2) << 16 | string.charAt(3) << 24;
            String string2 = this.file.read(n);
            this.push(new PyString(codecs.PyUnicode_DecodeUTF8(string2, "strict")));
        }

        private final void load_tuple() {
            PyObject[] pyObjectArray = new PyObject[this.marker()];
            this.pop(pyObjectArray);
            this.pop();
            this.push(new PyTuple(pyObjectArray));
        }

        private final void load_empty_tuple() {
            this.push(new PyTuple(Py.EmptyObjects));
        }

        private final void load_empty_list() {
            this.push(new PyList(Py.EmptyObjects));
        }

        private final void load_empty_dictionary() {
            this.push(new PyDictionary());
        }

        private final void load_list() {
            PyObject[] pyObjectArray = new PyObject[this.marker()];
            this.pop(pyObjectArray);
            this.pop();
            this.push(new PyList(pyObjectArray));
        }

        private final void load_dict() {
            int n = this.marker();
            PyDictionary pyDictionary = new PyDictionary();
            for (int i = 0; i < n; i += 2) {
                PyObject pyObject = this.pop();
                PyObject pyObject2 = this.pop();
                pyDictionary.__setitem__(pyObject2, pyObject);
            }
            this.pop();
            this.push(pyDictionary);
        }

        private final void load_inst() {
            PyObject[] pyObjectArray = new PyObject[this.marker()];
            this.pop(pyObjectArray);
            this.pop();
            String string = this.file.readlineNoNl();
            String string2 = this.file.readlineNoNl();
            PyObject pyObject = this.find_class(string, string2);
            PyObject pyObject2 = null;
            pyObject2 = pyObjectArray.length == 0 && pyObject instanceof PyClass && pyObject.__findattr__("__getinitargs__") == null ? new PyInstance((PyClass)pyObject) : pyObject.__call__(pyObjectArray);
            this.push(pyObject2);
        }

        private final void load_obj() {
            PyObject[] pyObjectArray = new PyObject[this.marker() - 1];
            this.pop(pyObjectArray);
            PyObject pyObject = this.pop();
            this.pop();
            PyObject pyObject2 = null;
            pyObject2 = pyObjectArray.length == 0 && pyObject instanceof PyClass && pyObject.__findattr__("__getinitargs__") == null ? new PyInstance((PyClass)pyObject) : pyObject.__call__(pyObjectArray);
            this.push(pyObject2);
        }

        private final void load_global() {
            String string = this.file.readlineNoNl();
            String string2 = this.file.readlineNoNl();
            PyObject pyObject = this.find_class(string, string2);
            this.push(pyObject);
        }

        private final PyObject find_class(String string, String string2) {
            PyObject pyObject;
            PyObject pyObject2 = dict.__finditem__("find_global");
            if (pyObject2 != null) {
                if (pyObject2 == Py.None) {
                    throw new PyException(UnpicklingError, "Global and instance pickles are not supported.");
                }
                return pyObject2.__call__(new PyString(string), new PyString(string2));
            }
            PyObject pyObject3 = Py.getSystemState().modules;
            PyObject pyObject4 = pyObject3.__finditem__(string.intern());
            if (pyObject4 == null) {
                pyObject4 = cPickle.importModule(string);
            }
            if ((pyObject = pyObject4.__findattr__(string2.intern())) == null) {
                throw new PyException(Py.SystemError, "Failed to import class " + string2 + " from module " + string);
            }
            return pyObject;
        }

        private final void load_reduce() {
            PyObject pyObject = this.pop();
            PyObject pyObject2 = this.pop();
            if (!(pyObject2 instanceof PyClass) && !(pyObject2 instanceof PyType) && safe_constructors.__finditem__(pyObject2) == null && pyObject2.__findattr__("__safe_for_unpickling__") == null) {
                throw new PyException(UnpicklingError, pyObject2 + " is not safe for unpickling");
            }
            PyObject pyObject3 = null;
            pyObject3 = pyObject == Py.None ? pyObject2.__findattr__("__basicnew__").__call__() : pyObject2.__call__(this.make_array(pyObject));
            this.push(pyObject3);
        }

        private final PyObject[] make_array(PyObject pyObject) {
            int n = pyObject.__len__();
            PyObject[] pyObjectArray = new PyObject[n];
            for (int i = 0; i < n; ++i) {
                pyObjectArray[i] = pyObject.__finditem__(i);
            }
            return pyObjectArray;
        }

        private final void load_pop() {
            this.pop();
        }

        private final void load_pop_mark() {
            this.pop(this.marker());
        }

        private final void load_dup() {
            this.push(this.peek());
        }

        private final void load_get() {
            String string = this.file.readlineNoNl();
            PyObject pyObject = (PyObject)this.memo.get(string);
            if (pyObject == null) {
                throw new PyException((PyObject)BadPickleGet, string);
            }
            this.push(pyObject);
        }

        private final void load_binget() {
            String string = String.valueOf((int)this.file.read(1).charAt(0));
            PyObject pyObject = (PyObject)this.memo.get(string);
            if (pyObject == null) {
                throw new PyException((PyObject)BadPickleGet, string);
            }
            this.push(pyObject);
        }

        private final void load_long_binget() {
            String string = this.file.read(4);
            int n = string.charAt(0) | string.charAt(1) << 8 | string.charAt(2) << 16 | string.charAt(3) << 24;
            String string2 = String.valueOf(n);
            PyObject pyObject = (PyObject)this.memo.get(string2);
            if (pyObject == null) {
                throw new PyException((PyObject)BadPickleGet, string2);
            }
            this.push(pyObject);
        }

        private final void load_put() {
            this.memo.put(this.file.readlineNoNl(), this.peek());
        }

        private final void load_binput() {
            char c = this.file.read(1).charAt(0);
            this.memo.put(String.valueOf((int)c), this.peek());
        }

        private final void load_long_binput() {
            String string = this.file.read(4);
            int n = string.charAt(0) | string.charAt(1) << 8 | string.charAt(2) << 16 | string.charAt(3) << 24;
            this.memo.put(String.valueOf(n), this.peek());
        }

        private final void load_append() {
            PyObject pyObject = this.pop();
            PyList pyList = (PyList)this.peek();
            pyList.append(pyObject);
        }

        private final void load_appends() {
            int n = this.marker();
            PyList pyList = (PyList)this.peek(n + 1);
            for (int i = n - 1; i >= 0; --i) {
                pyList.append(this.peek(i));
            }
            this.pop(n + 1);
        }

        private final void load_setitem() {
            PyObject pyObject = this.pop();
            PyObject pyObject2 = this.pop();
            PyDictionary pyDictionary = (PyDictionary)this.peek();
            pyDictionary.__setitem__(pyObject2, pyObject);
        }

        private final void load_setitems() {
            int n = this.marker();
            PyDictionary pyDictionary = (PyDictionary)this.peek(n + 1);
            for (int i = 0; i < n; i += 2) {
                PyObject pyObject = this.peek(i + 1);
                PyObject pyObject2 = this.peek(i);
                pyDictionary.__setitem__(pyObject, pyObject2);
            }
            this.pop(n + 1);
        }

        private final void load_build() {
            PyObject pyObject = this.pop();
            PyInstance pyInstance = (PyInstance)this.peek();
            PyObject pyObject2 = pyInstance.__findattr__("__setstate__");
            if (pyObject2 == null) {
                pyInstance.__dict__.__findattr__("update").__call__(pyObject);
            } else {
                pyObject2.__call__(pyObject);
            }
        }

        private final void load_mark() {
            this.push(this.mark);
        }

        private final PyObject load_stop() {
            return this.pop();
        }

        private final PyObject peek() {
            return this.stack[this.stackTop - 1];
        }

        private final PyObject peek(int n) {
            return this.stack[this.stackTop - n - 1];
        }

        private final PyObject pop() {
            PyObject pyObject = this.stack[--this.stackTop];
            this.stack[this.stackTop] = null;
            return pyObject;
        }

        private final void pop(int n) {
            for (int i = 0; i < n; ++i) {
                this.stack[--this.stackTop] = null;
            }
        }

        private final void pop(PyObject[] pyObjectArray) {
            int n = pyObjectArray.length;
            System.arraycopy(this.stack, this.stackTop - n, pyObjectArray, 0, n);
            this.stackTop -= n;
        }

        private final void push(PyObject pyObject) {
            if (this.stackTop >= this.stack.length) {
                PyObject[] pyObjectArray = new PyObject[(this.stackTop + 1) * 2];
                System.arraycopy(this.stack, 0, pyObjectArray, 0, this.stack.length);
                this.stack = pyObjectArray;
            }
            this.stack[this.stackTop++] = pyObject;
        }
    }

    private static class PickleMemo {
        private final int[] primes = new int[]{13, 61, 251, 1021, 4093, 5987, 9551, 15683, 19609, 31397, 65521, 131071, 262139, 524287, 1048573, 0x1FFFF7, 0x3FFFFD, 0x7FFFF1, 0xFFFFFD, 33554393, 0x3FFFFFB, 134217689, 0xFFFFFC7, 0x1FFFFFFD, 0x3FFFFFDD};
        private transient int[] keys = null;
        private transient int[] position;
        private transient Object[] values = null;
        private int size;
        private transient int filled;
        private transient int prime = 0;

        public PickleMemo(int n) {
            this.resize(n);
        }

        public PickleMemo() {
            this(4);
        }

        public synchronized int size() {
            return this.size;
        }

        private int findIndex(int n, Object object) {
            int[] nArray = this.keys;
            int n2 = nArray.length;
            int n3 = (n & Integer.MAX_VALUE) % n2;
            int n4 = n2 / 5;
            int n5;
            while ((n5 = nArray[n3]) != n || object != this.values[n3]) {
                if (this.values[n3] == null) {
                    return -1;
                }
                n3 = (n3 + n4) % n2;
            }
            return n3;
        }

        public int findPosition(int n, Object object) {
            int n2 = this.findIndex(n, object);
            if (n2 < 0) {
                return -1;
            }
            return this.position[n2];
        }

        public Object findValue(int n, Object object) {
            int n2 = this.findIndex(n, object);
            if (n2 < 0) {
                return null;
            }
            return this.values[n2];
        }

        private final void insertkey(int n, int n2, Object object) {
            int[] nArray = this.keys;
            int n3 = nArray.length;
            int n4 = (n & Integer.MAX_VALUE) % n3;
            int n5 = n3 / 5;
            while (true) {
                int n6 = nArray[n4];
                if (this.values[n4] == null) {
                    nArray[n4] = n;
                    this.position[n4] = n2;
                    this.values[n4] = object;
                    ++this.filled;
                    ++this.size;
                    break;
                }
                if (n6 == n && this.values[n4] == object) {
                    this.position[n4] = n2;
                    break;
                }
                n4 = (n4 + n5) % n3;
            }
        }

        private final synchronized void resize(int n) {
            int n2;
            for (n2 = this.prime; n2 < this.primes.length && this.primes[n2] < n; ++n2) {
            }
            if (this.primes[n2] < n) {
                throw Py.ValueError("can't make hashtable of size: " + n);
            }
            n = this.primes[n2];
            this.prime = n2;
            int[] nArray = this.keys;
            int[] nArray2 = this.position;
            Object[] objectArray = this.values;
            this.keys = new int[n];
            this.position = new int[n];
            this.values = new Object[n];
            this.size = 0;
            this.filled = 0;
            if (objectArray != null) {
                int n3 = objectArray.length;
                for (int i = 0; i < n3; ++i) {
                    Object object = objectArray[i];
                    if (object == null) continue;
                    this.insertkey(nArray[i], nArray2[i], object);
                }
            }
        }

        public void put(int n, int n2, Object object) {
            if (2 * this.filled > this.keys.length) {
                this.resize(this.keys.length + 1);
            }
            this.insertkey(n, n2, object);
        }
    }

    public static class Pickler {
        private IOFile file;
        private boolean bin;
        public boolean fast = false;
        private PickleMemo memo = new PickleMemo();
        public PyObject persistent_id = null;
        public PyObject inst_persistent_id = null;

        public Pickler(PyObject pyObject, boolean bl) {
            this.file = cPickle.createIOFile(pyObject);
            this.bin = bl;
        }

        public void dump(PyObject pyObject) {
            this.save(pyObject);
            this.file.write('.');
            this.file.flush();
        }

        private static final int get_id(PyObject pyObject) {
            return System.identityHashCode(pyObject);
        }

        private void put(int n) {
            if (this.bin) {
                if (n < 256) {
                    this.file.write('q');
                    this.file.write((char)n);
                    return;
                }
                this.file.write('r');
                this.file.write((char)(n & 0xFF));
                this.file.write((char)(n >>> 8 & 0xFF));
                this.file.write((char)(n >>> 16 & 0xFF));
                this.file.write((char)(n >>> 24 & 0xFF));
                return;
            }
            this.file.write('p');
            this.file.write(String.valueOf(n));
            this.file.write("\n");
        }

        private void get(int n) {
            if (this.bin) {
                if (n < 256) {
                    this.file.write('h');
                    this.file.write((char)n);
                    return;
                }
                this.file.write('j');
                this.file.write((char)(n & 0xFF));
                this.file.write((char)(n >>> 8 & 0xFF));
                this.file.write((char)(n >>> 16 & 0xFF));
                this.file.write((char)(n >>> 24 & 0xFF));
                return;
            }
            this.file.write('g');
            this.file.write(String.valueOf(n));
            this.file.write("\n");
        }

        private void save(PyObject pyObject) {
            this.save(pyObject, false);
        }

        private void save(PyObject pyObject, boolean bl) {
            PyObject pyObject2;
            PyObject pyObject3;
            PyObject pyObject4;
            if (!bl && this.persistent_id != null && (pyObject4 = this.persistent_id.__call__(pyObject)) != Py.None) {
                this.save_pers(pyObject4);
                return;
            }
            int n = Pickler.get_id(pyObject);
            PyType pyType = pyObject.getType();
            if (pyType == TupleType && pyObject.__len__() == 0) {
                if (this.bin) {
                    this.save_empty_tuple(pyObject);
                } else {
                    this.save_tuple(pyObject);
                }
                return;
            }
            int n2 = this.getMemoPosition(n, pyObject);
            if (n2 >= 0) {
                this.get(n2);
                return;
            }
            if (this.save_type(pyObject, pyType)) {
                return;
            }
            if (this.inst_persistent_id != null && (pyObject3 = this.inst_persistent_id.__call__(pyObject)) != Py.None) {
                this.save_pers(pyObject3);
                return;
            }
            pyObject3 = null;
            PyObject pyObject5 = dispatch_table.__finditem__(pyType);
            if (pyObject5 == null) {
                pyObject5 = pyObject.__findattr__("__reduce__");
                if (pyObject5 == null) {
                    throw new PyException(UnpickleableError, pyObject);
                }
                pyObject3 = pyObject5.__call__();
            } else {
                pyObject3 = pyObject5.__call__(pyObject);
            }
            if (pyObject3 instanceof PyString) {
                this.save_global(pyObject, pyObject3);
                return;
            }
            if (!(pyObject3 instanceof PyTuple)) {
                throw new PyException(PicklingError, "Value returned by " + pyObject5.__repr__() + " must be a tuple");
            }
            int n3 = pyObject3.__len__();
            if (n3 != 2 && n3 != 3) {
                throw new PyException(PicklingError, "tuple returned by " + pyObject5.__repr__() + " must contain only two or three elements");
            }
            PyObject pyObject6 = pyObject3.__finditem__(0);
            PyObject pyObject7 = pyObject3.__finditem__(1);
            PyObject pyObject8 = pyObject2 = n3 > 2 ? pyObject3.__finditem__(2) : Py.None;
            if (!(pyObject7 instanceof PyTuple) && pyObject7 != Py.None) {
                throw new PyException(PicklingError, "Second element of tupe returned by " + pyObject5.__repr__() + " must be a tuple");
            }
            this.save_reduce(pyObject6, pyObject7, pyObject2);
            this.put(this.putMemo(n, pyObject));
        }

        private final void save_pers(PyObject pyObject) {
            if (!this.bin) {
                this.file.write('P');
                this.file.write(pyObject.toString());
                this.file.write("\n");
            } else {
                this.save(pyObject, true);
                this.file.write('Q');
            }
        }

        private final void save_reduce(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            this.save(pyObject);
            this.save(pyObject2);
            this.file.write('R');
            if (pyObject3 != Py.None) {
                this.save(pyObject3);
                this.file.write('b');
            }
        }

        private final boolean save_type(PyObject pyObject, PyType pyType) {
            if (pyType == NoneType) {
                this.save_none(pyObject);
            } else if (pyType == StringType) {
                this.save_string(pyObject);
            } else if (pyType == IntType) {
                this.save_int(pyObject);
            } else if (pyType == LongType) {
                this.save_long(pyObject);
            } else if (pyType == FloatType) {
                this.save_float(pyObject);
            } else if (pyType == TupleType) {
                this.save_tuple(pyObject);
            } else if (pyType == ListType) {
                this.save_list(pyObject);
            } else if (pyType == DictionaryType || pyType == StringMapType) {
                this.save_dict(pyObject);
            } else if (pyType == InstanceType) {
                this.save_inst((PyInstance)pyObject);
            } else if (pyType == ClassType) {
                this.save_global(pyObject);
            } else if (pyType == TypeType) {
                this.save_global(pyObject);
            } else if (pyType == FunctionType) {
                this.save_global(pyObject);
            } else if (pyType == BuiltinFunctionType) {
                this.save_global(pyObject);
            } else {
                return false;
            }
            return true;
        }

        private final void save_none(PyObject pyObject) {
            this.file.write('N');
        }

        private final void save_int(PyObject pyObject) {
            if (this.bin) {
                int n = ((PyInteger)pyObject).getValue();
                char c = (char)(n & 0xFF);
                char c2 = (char)(n >>> 8 & 0xFF);
                char c3 = (char)(n >>> 16 & 0xFF);
                char c4 = (char)(n >>> 24 & 0xFF);
                if (c3 == '\u0000' && c4 == '\u0000') {
                    if (c2 == '\u0000') {
                        this.file.write('K');
                        this.file.write(c);
                        return;
                    }
                    this.file.write('M');
                    this.file.write(c);
                    this.file.write(c2);
                    return;
                }
                this.file.write('J');
                this.file.write(c);
                this.file.write(c2);
                this.file.write(c3);
                this.file.write(c4);
            } else {
                this.file.write('I');
                this.file.write(pyObject.toString());
                this.file.write("\n");
            }
        }

        private final void save_long(PyObject pyObject) {
            this.file.write('L');
            this.file.write(pyObject.toString());
            this.file.write("\n");
        }

        private final void save_float(PyObject pyObject) {
            if (this.bin) {
                this.file.write('G');
                double d = ((PyFloat)pyObject).getValue();
                long l = Double.doubleToLongBits(d);
                this.file.write((char)(l >>> 56 & 0xFFL));
                this.file.write((char)(l >>> 48 & 0xFFL));
                this.file.write((char)(l >>> 40 & 0xFFL));
                this.file.write((char)(l >>> 32 & 0xFFL));
                this.file.write((char)(l >>> 24 & 0xFFL));
                this.file.write((char)(l >>> 16 & 0xFFL));
                this.file.write((char)(l >>> 8 & 0xFFL));
                this.file.write((char)(l >>> 0 & 0xFFL));
            } else {
                this.file.write('F');
                this.file.write(pyObject.toString());
                this.file.write("\n");
            }
        }

        private final void save_string(PyObject pyObject) {
            boolean bl = ((PyString)pyObject).isunicode();
            String string = pyObject.toString();
            if (this.bin) {
                int n;
                if (bl) {
                    string = codecs.PyUnicode_EncodeUTF8(string, "struct");
                }
                if ((n = string.length()) < 256 && !bl) {
                    this.file.write('U');
                    this.file.write((char)n);
                } else {
                    if (bl) {
                        this.file.write('X');
                    } else {
                        this.file.write('T');
                    }
                    this.file.write((char)(n & 0xFF));
                    this.file.write((char)(n >>> 8 & 0xFF));
                    this.file.write((char)(n >>> 16 & 0xFF));
                    this.file.write((char)(n >>> 24 & 0xFF));
                }
                this.file.write(string);
            } else {
                if (bl) {
                    this.file.write('V');
                    this.file.write(codecs.PyUnicode_EncodeRawUnicodeEscape(string, "strict", true));
                } else {
                    this.file.write('S');
                    this.file.write(pyObject.__repr__().toString());
                }
                this.file.write("\n");
            }
            this.put(this.putMemo(Pickler.get_id(pyObject), pyObject));
        }

        private final void save_tuple(PyObject pyObject) {
            int n;
            int n2 = Pickler.get_id(pyObject);
            this.file.write('(');
            int n3 = pyObject.__len__();
            for (n = 0; n < n3; ++n) {
                this.save(pyObject.__finditem__(n));
            }
            if (n3 > 0 && (n = this.getMemoPosition(n2, pyObject)) >= 0) {
                if (this.bin) {
                    this.file.write('1');
                    this.get(n);
                    return;
                }
                for (int i = 0; i < n3 + 1; ++i) {
                    this.file.write('0');
                }
                this.get(n);
                return;
            }
            this.file.write('t');
            this.put(this.putMemo(n2, pyObject));
        }

        private final void save_empty_tuple(PyObject pyObject) {
            this.file.write(')');
        }

        private final void save_list(PyObject pyObject) {
            boolean bl;
            if (this.bin) {
                this.file.write(']');
            } else {
                this.file.write('(');
                this.file.write('l');
            }
            this.put(this.putMemo(Pickler.get_id(pyObject), pyObject));
            int n = pyObject.__len__();
            boolean bl2 = bl = this.bin && n > 1;
            if (bl) {
                this.file.write('(');
            }
            for (int i = 0; i < n; ++i) {
                this.save(pyObject.__finditem__(i));
                if (bl) continue;
                this.file.write('a');
            }
            if (bl) {
                this.file.write('e');
            }
        }

        private final void save_dict(PyObject pyObject) {
            boolean bl;
            if (this.bin) {
                this.file.write('}');
            } else {
                this.file.write('(');
                this.file.write('d');
            }
            this.put(this.putMemo(Pickler.get_id(pyObject), pyObject));
            PyObject pyObject2 = pyObject.invoke("keys");
            int n = pyObject2.__len__();
            boolean bl2 = bl = this.bin && n > 1;
            if (bl) {
                this.file.write('(');
            }
            for (int i = 0; i < n; ++i) {
                PyObject pyObject3 = pyObject2.__finditem__(i);
                PyObject pyObject4 = pyObject.__finditem__(pyObject3);
                this.save(pyObject3);
                this.save(pyObject4);
                if (bl) continue;
                this.file.write('s');
            }
            if (bl) {
                this.file.write('u');
            }
        }

        private final void save_inst(PyInstance pyInstance) {
            int n;
            if (pyInstance instanceof PyJavaInstance) {
                throw new PyException(PicklingError, "Unable to pickle java objects.");
            }
            PyClass pyClass = pyInstance.instclass;
            PySequence pySequence = null;
            PyObject pyObject = pyInstance.__findattr__("__getinitargs__");
            if (pyObject != null) {
                pySequence = (PySequence)pyObject.__call__();
                this.keep_alive(pySequence);
            }
            this.file.write('(');
            if (this.bin) {
                this.save(pyClass);
            }
            if (pySequence != null) {
                n = pySequence.__len__();
                for (int i = 0; i < n; ++i) {
                    this.save(pySequence.__finditem__(i));
                }
            }
            n = this.putMemo(Pickler.get_id(pyInstance), pyInstance);
            if (this.bin) {
                this.file.write('o');
                this.put(n);
            } else {
                this.file.write('i');
                this.file.write(pyClass.__findattr__("__module__").toString());
                this.file.write("\n");
                this.file.write(pyClass.__name__);
                this.file.write("\n");
                this.put(n);
            }
            PyObject pyObject2 = null;
            PyObject pyObject3 = pyInstance.__findattr__("__getstate__");
            if (pyObject3 == null) {
                pyObject2 = pyInstance.__dict__;
            } else {
                pyObject2 = pyObject3.__call__();
                this.keep_alive(pyObject2);
            }
            this.save(pyObject2);
            this.file.write('b');
        }

        private final void save_global(PyObject pyObject) {
            this.save_global(pyObject, null);
        }

        private final void save_global(PyObject pyObject, PyObject pyObject2) {
            PyObject pyObject3;
            if (pyObject2 == null) {
                pyObject2 = pyObject.__findattr__("__name__");
            }
            if ((pyObject3 = pyObject.__findattr__("__module__")) == null || pyObject3 == Py.None) {
                pyObject3 = cPickle.whichmodule(pyObject, pyObject2);
            }
            this.file.write('c');
            this.file.write(pyObject3.toString());
            this.file.write("\n");
            this.file.write(pyObject2.toString());
            this.file.write("\n");
            this.put(this.putMemo(Pickler.get_id(pyObject), pyObject));
        }

        private final int getMemoPosition(int n, Object object) {
            return this.memo.findPosition(n, object);
        }

        private final int putMemo(int n, PyObject pyObject) {
            int n2 = this.memo.size() + 1;
            this.memo.put(n, n2, pyObject);
            return n2;
        }

        private final void keep_alive(PyObject pyObject) {
            int n = System.identityHashCode(this.memo);
            PyList pyList = (PyList)this.memo.findValue(n, this.memo);
            if (pyList == null) {
                pyList = new PyList();
                this.memo.put(n, -1, pyList);
            }
            pyList.append(pyObject);
        }
    }

    static class ObjectIOFile
    implements IOFile {
        char[] charr = new char[1];
        StringBuffer buff = new StringBuffer();
        PyObject write;
        PyObject read;
        PyObject readline;
        final int BUF_SIZE = 256;

        ObjectIOFile(PyObject pyObject) {
            this.write = pyObject.__findattr__("write");
            this.read = pyObject.__findattr__("read");
            this.readline = pyObject.__findattr__("readline");
        }

        public void write(String string) {
            this.buff.append(string);
            if (this.buff.length() > 256) {
                this.flush();
            }
        }

        public void write(char c) {
            this.buff.append(c);
            if (this.buff.length() > 256) {
                this.flush();
            }
        }

        public void flush() {
            this.write.__call__(new PyString(this.buff.toString()));
            this.buff.setLength(0);
        }

        public String read(int n) {
            return this.read.__call__(new PyInteger(n)).toString();
        }

        public String readlineNoNl() {
            String string = this.readline.__call__().toString();
            return string.substring(0, string.length() - 1);
        }
    }

    static class FileIOFile
    implements IOFile {
        PyFile file;

        FileIOFile(PyObject pyObject) {
            this.file = (PyFile)pyObject.__tojava__(class$org$python$core$PyFile == null ? (class$org$python$core$PyFile = cPickle.class$("org.python.core.PyFile")) : class$org$python$core$PyFile);
            if (this.file.closed) {
                throw Py.ValueError("I/O operation on closed file");
            }
        }

        public void write(String string) {
            this.file.write(string);
        }

        public void write(char c) {
            this.file.write(cStringIO.getString(c));
        }

        public void flush() {
        }

        public String read(int n) {
            return this.file.read(n).toString();
        }

        public String readlineNoNl() {
            String string = this.file.readline().toString();
            return string.substring(0, string.length() - 1);
        }
    }

    static class cStringIOFile
    implements IOFile {
        cStringIO.StringIO file;

        cStringIOFile(PyObject pyObject) {
            this.file = (cStringIO.StringIO)pyObject.__tojava__(class$java$lang$Object == null ? (class$java$lang$Object = cPickle.class$("java.lang.Object")) : class$java$lang$Object);
        }

        public void write(String string) {
            this.file.write(string);
        }

        public void write(char c) {
            this.file.writeChar(c);
        }

        public void flush() {
        }

        public String read(int n) {
            return this.file.read(n);
        }

        public String readlineNoNl() {
            return this.file.readlineNoNl();
        }
    }

    static interface IOFile {
        public void write(String var1);

        public void write(char var1);

        public void flush();

        public String read(int var1);

        public String readlineNoNl();
    }
}

