/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.Allocator;
import javolution.context.AllocatorContext;
import javolution.context.Context;
import javolution.context.ObjectFactory;
import javolution.util.FastMap;
import javolution.util.FastTable;

public class PoolContext
extends AllocatorContext {
    private static final ThreadLocal FACTORY_TO_ALLOCATOR = new ThreadLocal(){

        protected Object initialValue() {
            return new FastMap();
        }
    };
    private static final ThreadLocal ACTIVE_ALLOCATORS = new ThreadLocal(){

        protected Object initialValue() {
            return new FastTable();
        }
    };

    public static void enter() {
        Context.enter(PoolContext.class);
    }

    public static void exit() {
        Context.exit(PoolContext.class);
    }

    @Override
    protected void deactivate() {
        FastTable allocators = (FastTable)ACTIVE_ALLOCATORS.get();
        int i = 0;
        int n = allocators.size();
        while (i < n) {
            ((Allocator)allocators.get((int)i++)).user = null;
        }
        allocators.clear();
    }

    @Override
    protected Allocator getAllocator(ObjectFactory factory) {
        FastMap factoryToAllocator = (FastMap)FACTORY_TO_ALLOCATOR.get();
        PoolAllocator allocator = (PoolAllocator)factoryToAllocator.get(factory);
        if (allocator == null) {
            allocator = new PoolAllocator(factory);
            factoryToAllocator.put(factory, allocator);
        }
        if (allocator.user == null) {
            allocator.user = Thread.currentThread();
            FastTable activeAllocators = (FastTable)ACTIVE_ALLOCATORS.get();
            activeAllocators.add(allocator);
        }
        return allocator;
    }

    @Override
    protected void enterAction() {
        this.getOuter().getAllocatorContext().deactivate();
    }

    @Override
    protected void exitAction() {
        this.deactivate();
    }

    private static final class PoolAllocator
    extends Allocator {
        private static final FastMap FACTORY_TO_POOL = new FastMap();
        private final ObjectFactory _factory;
        private final FastTable _recycled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PoolAllocator(ObjectFactory factory) {
            this._factory = factory;
            FastMap fastMap = FACTORY_TO_POOL;
            synchronized (fastMap) {
                FastTable recycled = (FastTable)FACTORY_TO_POOL.get(factory);
                if (recycled == null) {
                    recycled = new FastTable();
                    FACTORY_TO_POOL.put(factory, recycled);
                }
                this._recycled = recycled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object allocate() {
            if (this._recycled.isEmpty()) {
                return this._factory.create();
            }
            FastTable fastTable = this._recycled;
            synchronized (fastTable) {
                return this._recycled.removeLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void recycle(Object object) {
            if (this._factory.doCleanup()) {
                this._factory.cleanup(object);
            }
            FastTable fastTable = this._recycled;
            synchronized (fastTable) {
                this._recycled.addLast(object);
            }
        }

        public String toString() {
            return "Pool allocator for " + this._factory.getClass();
        }
    }
}

