// ============================================================
// Copyright (C) 2009 Kuzumeji Hacker. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: DateUtil.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.util;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
/**
 * DateUtil
 * @author nilcy
 */
public final class DateUtil {
    /** HIDDEN CONSTRUCTOR */
    private DateUtil() {
        // NOP
    }
    /**
     * @param aFrom
     * @return Dates by Week
     */
    public static List<Date> getDatesByWeek(Date aFrom) {
        Date from = DateUtils.truncate(aFrom, Calendar.DAY_OF_MONTH);
        Calendar cal = Calendar.getInstance();
        while (true) {
            cal.setTime(from);
            if (cal.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY) {
                break;
            }
            from = DateUtils.addDays(from, -1);
        }
        Date to = DateUtils.addWeeks(from, 1);
        return getDatesByRange(from, to);
    }
    /**
     * @param aFrom
     * @return Dates by Month
     */
    public static List<Date> getDatesByMonth(Date aFrom) {
        Date from = DateUtils.truncate(aFrom, Calendar.DAY_OF_MONTH);
        Calendar cal = Calendar.getInstance();
        while (true) {
            cal.setTime(from);
            if (cal.get(Calendar.DAY_OF_MONTH) == 1) {
                break;
            }
            from = DateUtils.addDays(from, -1);
        }
        Date to = DateUtils.addMonths(from, 1);
        return getDatesByRange(from, to);
    }
    /**
     * @param aFrom
     * @return Dates by Year
     */
    public static List<Date> getDatesByYear(Date aFrom) {
        Date from = DateUtils.truncate(aFrom, Calendar.DAY_OF_MONTH);
        Calendar cal = Calendar.getInstance();
        cal.setTime(from);
        cal.set(Calendar.MONTH, Calendar.JANUARY);
        cal.set(Calendar.DAY_OF_MONTH, 1);
        from = cal.getTime();
        Date to = DateUtils.addYears(from, 1);
        List<Date> dates = new ArrayList<Date>(0);
        for (Date d = from; !DateUtils.isSameDay(d, to); d = DateUtils.addMonths(d, 1)) {
            dates.add(d);
        }
        return dates;
    }
    /**
     * @param aFrom
     * @param aTo
     * @return Dates by Range
     */
    public static List<Date> getDatesByRange(Date aFrom, Date aTo) {
        List<Date> dates = new ArrayList<Date>(0);
        for (Date d = aFrom; !DateUtils.isSameDay(d, aTo); d = DateUtils.addDays(d, 1)) {
            dates.add(d);
        }
        return dates;
    }
    /**
     * @param aDate Date
     * @return First Date of Month
     */
    public static Date getFirstDateOfMonth(Date aDate) {
        Date from = DateUtils.truncate(aDate, Calendar.DAY_OF_MONTH);
        Calendar cal = Calendar.getInstance();
        cal.setTime(from);
        cal.set(Calendar.DAY_OF_MONTH, 1);
        return cal.getTime();
    }
    /**
     * @return First Date of This Month
     */
    public static Date getFirstDateOfThisMonth() {
        Date from = DateUtils.truncate(new Date(), Calendar.DAY_OF_MONTH);
        Calendar cal = Calendar.getInstance();
        cal.setTime(from);
        cal.set(Calendar.DAY_OF_MONTH, 1);
        return cal.getTime();
    }
    /**
     * @param arg
     */
    public static void main(String[] arg) {
        System.out.println("1. getDatesByWeek");
        List<Date> datesByWeek = getDatesByWeek(new Date());
        for (Date d : datesByWeek) {
            System.out.println(d);
        }
        System.out.println("2. getDatesByMonth");
        List<Date> datesByMonth = getDatesByMonth(new Date());
        for (Date d : datesByMonth) {
            System.out.println(d);
        }
        System.out.println("3. getDatesByYear");
        List<Date> datesByYear = getDatesByYear(new Date());
        for (Date d : datesByYear) {
            System.out.println(d);
        }
        System.out.println("4. getFirstDateOfMonth");
        System.out.println(getFirstDateOfMonth(new Date()));
    }
}
