// ============================================================
// Copyright (C) 2009 Kuzumeji Hacker. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: SessionTimeoutListener.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.listener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import kuzumeji.entity.idm.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 * SessionTimeoutListener
 * @author nilcy
 */
public class SessionTimeoutListener implements HttpSessionListener {
    /** Logger */
    private static Log LOG = LogFactory.getLog(SessionTimeoutListener.class);
    /**
     * @see javax.servlet.http.HttpSessionListener#sessionCreated(javax.servlet.http.HttpSessionEvent)
     */
    public void sessionCreated(HttpSessionEvent aEvt) {
        // NOP
    }
    /**
     * @see javax.servlet.http.HttpSessionListener#sessionDestroyed(javax.servlet.http.HttpSessionEvent)
     */
    public void sessionDestroyed(HttpSessionEvent aEvt) {
        HttpSession session = aEvt.getSession();
        User loginUser = (User) session.getAttribute("loginUser");
        if (loginUser == null) return;
        LOG.info("sessionDestroyed: " + loginUser.getAccount());
    }
}
