// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: User.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.idm;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import kuzumeji.entity.BaseEntity;
import kuzumeji.entity.erp.Worker;
import org.hibernate.validator.Length;
import org.jboss.seam.annotations.security.management.UserEnabled;
import org.jboss.seam.annotations.security.management.UserPassword;
import org.jboss.seam.annotations.security.management.UserPrincipal;
import org.jboss.seam.annotations.security.management.UserRoles;
/**
 * IDM User
 * @author nilcy
 */
@Entity
@Table(name = "user", uniqueConstraints = @UniqueConstraint(columnNames = "account"))
public class User extends BaseEntity {
    /** S/N */
    private static final long serialVersionUID = 6368734442192368866L;
    /** User Account */
    private String account;
    /** User Password */
    private String password;
    /** Enabled */
    private boolean enabled = true;
    /** User Role List */
    private List<Role> roles;
    /** Last Login Time Stamp */
    private Date lastLoginTime;
    /** Login Successed Count */
    private Long loginCount;
    /** Login Failed Count */
    private Long failedCount;
    /** Worker */
    private Worker worker;
    /** Constructor */
    public User() {
        // NOP
    }
    /**
     * getter for User Account
     * @return User Account
     */
    @UserPrincipal
    @Column(name = "account", nullable = false)
    @Length(min = 4, max = 20)
    public String getAccount() {
        return this.account;
    }
    /**
     * setter for User Account
     * @param aAccount User Account
     */
    public void setAccount(String aAccount) {
        this.account = aAccount;
    }
    /**
     * getter for User Password
     * <ul>
     * <li>@Length CAN NOT USE. Password is SHA Value.</li>
     * </ul>
     * @return User Password
     */
    @UserPassword(hash = "SHA")
    @Column(name = "password", nullable = false)
    public String getPassword() {
        return this.password;
    }
    /**
     * setter for User Password
     * @param aPassword User Password
     */
    public void setPassword(String aPassword) {
        this.password = aPassword;
    }
    /**
     * getter for Enabled
     * @return Enabled
     */
    @UserEnabled
    @Column(name = "enabled", nullable = false)
    public boolean isEnabled() {
        return this.enabled;
    }
    /**
     * setter for Enabled
     * @param aEnabled Enabled
     */
    public void setEnabled(boolean aEnabled) {
        this.enabled = aEnabled;
    }
    /**
     * getter for User Role List
     * @return User Role List
     */
    @UserRoles
    @ManyToMany
    @JoinTable(name = "user_role", joinColumns = @JoinColumn(name = "user_id"), inverseJoinColumns = @JoinColumn(name = "member_of_role"))
    public List<Role> getRoles() {
        return this.roles;
    }
    /**
     * setter for User Role List
     * @param aRoles User Role List
     */
    public void setRoles(List<Role> aRoles) {
        this.roles = aRoles;
    }
    /**
     * getter for Last Login Time Stamp
     * @return Last Login Time Stamp
     */
    @Column(name = "last_login_time", nullable = true)
    @Basic
    @Temporal(TemporalType.TIMESTAMP)
    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }
    /**
     * setter for Last Login Time Stamp
     * @param aLastLoginTime Last Login Time Stamp
     */
    public void setLastLoginTime(Date aLastLoginTime) {
        this.lastLoginTime = aLastLoginTime;
    }
    /**
     * getter for Login Successed Count
     * @return Login Successed Count
     */
    @Column(name = "login_count", nullable = true)
    public Long getLoginCount() {
        return this.loginCount;
    }
    /**
     * setter for Login Successed Count
     * @param aLoginCount Login Successed Count
     */
    public void setLoginCount(Long aLoginCount) {
        this.loginCount = aLoginCount;
    }
    /**
     * getter for Login Failed Count
     * @return Login Failed Count
     */
    @Column(name = "failed_count", nullable = true)
    public Long getFailedCount() {
        return this.failedCount;
    }
    /**
     * setter for Login Failed Count
     * @param aFailedCount Login Failed Count
     */
    public void setFailedCount(Long aFailedCount) {
        this.failedCount = aFailedCount;
    }
    /**
     * getter for Worker
     * @return Worker
     */
    @OneToOne(mappedBy = "user", cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    public Worker getWorker() {
        return this.worker;
    }
    /**
     * setter for Worker
     * @param aWorker Worker
     */
    public void setWorker(Worker aWorker) {
        this.worker = aWorker;
    }
    // ============================================================
    /**
     * Increment Login Successed Count
     */
    @Transient
    public void incrementLoginCount() {
        long lc = (getLoginCount() != null) ? getLoginCount() : 0L;
        setLoginCount(lc + 1);
    }
}
