// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: PlanWork.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp.mng;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import kuzumeji.entity.Person;
import kuzumeji.entity.TrackEntity;
import kuzumeji.entity.def.ActivityRole;
/**
 * Plan Work
 * @author nilcy
 */
@Entity
@Table(name = "plan_work", uniqueConstraints = { @UniqueConstraint(columnNames = { "activity_id", "worker_id" }) })
public class PlanWork extends TrackEntity {
    /** S/N */
    private static final long serialVersionUID = 3000019109591326709L;
    /** Activity */
    private Activity activity;
    /** Person */
    private Person person;
    /** Activity Role */
    private ActivityRole activityRole = ActivityRole.MEMBER;
    /** Prime Cost */
    private Long primeCost = 0L;
    /** Unit Cost */
    private Long unitCost = 0L;
    /** Plan Work Details */
    private List<PlanWorkDetail> planWorkDetails = new ArrayList<PlanWorkDetail>(0);
    /**
     * Constructor
     */
    public PlanWork() {
        // NOP
    }
    /**
     * @return Activity
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "activity_id", referencedColumnName = "id", nullable = false, insertable = true, updatable = true)
    public Activity getActivity() {
        return this.activity;
    }
    /**
     * @param aActivity Activity
     */
    public void setActivity(Activity aActivity) {
        this.activity = aActivity;
    }
    /**
     * @return Person
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "worker_id", referencedColumnName = "id", nullable = false, insertable = true, updatable = true)
    public Person getWorker() {
        return this.person;
    }
    /**
     * @param aPerson Person
     */
    public void setWorker(Person aPerson) {
        this.person = aPerson;
    }
    /**
     * @return Activity Role
     */
    @Column(name = "activity_role", nullable = true, insertable = true, updatable = true)
    @Enumerated(EnumType.STRING)
    public ActivityRole getActivityRole() {
        return this.activityRole;
    }
    /**
     * @param aActivityRole Activity Role
     */
    public void setActivityRole(ActivityRole aActivityRole) {
        this.activityRole = aActivityRole;
    }
    /**
     * @return Prime Cost
     */
    @Column(name = "prime_cost", nullable = false, insertable = true, updatable = true)
    public Long getPrimeCost() {
        return this.primeCost;
    }
    /**
     * @param aPrimeCost Prime Cost
     */
    public void setPrimeCost(Long aPrimeCost) {
        this.primeCost = aPrimeCost;
    }
    /**
     * @return Unit Cost
     */
    @Column(name = "unit_cost", nullable = false, insertable = true, updatable = true)
    public Long getUnitCost() {
        return this.unitCost;
    }
    /**
     * @param aUnitCost Unit Cost
     */
    public void setUnitCost(Long aUnitCost) {
        this.unitCost = aUnitCost;
    }
    /**
     * @return Plan Work Details
     */
    @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.LAZY, mappedBy = "planWork")
    public List<PlanWorkDetail> getPlanWorkDetails() {
        return this.planWorkDetails;
    }
    /**
     * @param aPlanWorkDetails Plan Work Details
     */
    public void setPlanWorkDetails(List<PlanWorkDetail> aPlanWorkDetails) {
        this.planWorkDetails = aPlanWorkDetails;
    }
}
