// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: PlanExpense.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp.mng;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import kuzumeji.entity.TrackEntity;
import kuzumeji.entity.def.ExpenseCat;
import org.hibernate.validator.Length;
/**
 * Plan Expense
 * @author nilcy
 */
@Entity
@Table(name = "plan_expense", uniqueConstraints = {})
public class PlanExpense extends TrackEntity {
    /** S/N */
    private static final long serialVersionUID = -7564058930525387006L;
    /** Activity */
    private Activity activity;
    /** Expense Category */
    private ExpenseCat cat = ExpenseCat.ACTIVITY;
    /** Expense Item */
    private String item;
    /** Expense Name */
    private String name;
    /** Text */
    private String text;
    /** Unit Price */
    private Long unitPrice;
    /** Amount */
    private Long amount;
    /** Plan Expense Details */
    private List<PlanExpenseDetail> planExpenseDetails = new ArrayList<PlanExpenseDetail>(0);
    /**
     * Constructor
     */
    public PlanExpense() {
        // NOP
    }
    /**
     * @return Activity
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "activity_id", referencedColumnName = "id", nullable = false, insertable = true, updatable = true)
    public Activity getActivity() {
        return this.activity;
    }
    /**
     * @param aActivity Activity
     */
    public void setActivity(Activity aActivity) {
        this.activity = aActivity;
    }
    /**
     * @return Expense Category
     */
    @Column(name = "cat", nullable = false, insertable = true, updatable = true)
    public ExpenseCat getCat() {
        return this.cat;
    }
    /**
     * @param aCat Expense Category
     */
    public void setCat(ExpenseCat aCat) {
        this.cat = aCat;
    }
    /**
     * @return Expense Item
     */
    @Column(name = "item", nullable = false, insertable = true, updatable = true)
    public String getItem() {
        return this.item;
    }
    /**
     * @param aItem Expense Item
     */
    public void setItem(String aItem) {
        this.item = aItem;
    }
    /**
     * @return Expense Name
     */
    @Column(name = "name", nullable = true, insertable = true, updatable = true)
    @Length(max = 100)
    public String getName() {
        return this.name;
    }
    /**
     * @param aCostName Expense Name
     */
    public void setName(String aCostName) {
        this.name = aCostName;
    }
    /**
     * @return Text
     */
    @Column(name = "text", nullable = true, insertable = true, updatable = true)
    @Length(max = 100)
    public String getText() {
        return this.text;
    }
    /**
     * @param aText Text
     */
    public void setText(String aText) {
        this.text = aText;
    }
    /**
     * @return Unit Price
     */
    @Column(name = "unit_price", nullable = false, insertable = true, updatable = true)
    public Long getUnitPrice() {
        return this.unitPrice;
    }
    /**
     * @param aUnitPrice Unit Price
     */
    public void setUnitPrice(Long aUnitPrice) {
        this.unitPrice = aUnitPrice;
    }
    /**
     * @return Amount
     */
    @Column(name = "amount", nullable = false, insertable = true, updatable = true)
    public Long getAmount() {
        return this.amount;
    }
    /**
     * @param aAmount Amount
     */
    public void setAmount(Long aAmount) {
        this.amount = aAmount;
    }
    /**
     * @return Plan Expense Details
     */
    @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.LAZY, mappedBy = "planExpense")
    public List<PlanExpenseDetail> getPlanExpenseDetails() {
        return this.planExpenseDetails;
    }
    /**
     * @param aPlanExpenseDetails Plan Expense Details
     */
    public void setPlanExpenseDetails(List<PlanExpenseDetail> aPlanExpenseDetails) {
        this.planExpenseDetails = aPlanExpenseDetails;
    }
}
