// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: Period.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp.mng;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import kuzumeji.entity.BaseEntity;
/**
 * Period
 * @author nilcy
 */
@Entity
@Table(name = "period", uniqueConstraints = { @UniqueConstraint(columnNames = { "start_date" }) })
public class Period extends BaseEntity {
    /** S/N */
    private static final long serialVersionUID = 2761442132922024227L;
    /** Start Date */
    private Date startDate;
    /** End Date */
    private Date endDate;
    /** Actual Period */
    private List<ActualPeriod> actualPeriods = new ArrayList<ActualPeriod>(0);
    /**
     * Constructor
     */
    public Period() {
        // NOP
    }
    /**
     * @return Start Date
     */
    @Column(name = "start_date", nullable = true, insertable = true, updatable = true)
    @Basic
    @Temporal(TemporalType.DATE)
    public Date getStartDate() {
        return this.startDate;
    }
    /**
     * @param aStartDate Start Date
     */
    public void setStartDate(Date aStartDate) {
        this.startDate = aStartDate;
    }
    /**
     * @return End Date
     */
    @Column(name = "end_date", nullable = true, insertable = true, updatable = true)
    @Basic
    @Temporal(TemporalType.DATE)
    public Date getEndDate() {
        return this.endDate;
    }
    /**
     * @param aEnd End Date
     */
    public void setEndDate(Date aEnd) {
        this.endDate = aEnd;
    }
    /**
     * @return Actual Period List
     */
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "period")
    public List<ActualPeriod> getActualPeriods() {
        return this.actualPeriods;
    }
    /**
     * @param aActualPeriods Actual Period List
     */
    public void setActualPeriods(List<ActualPeriod> aActualPeriods) {
        this.actualPeriods = aActualPeriods;
    }
}
