// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: ActualPeriod.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp.mng;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import kuzumeji.entity.Person;
import kuzumeji.entity.TrackEntity;
import kuzumeji.entity.def.ApprovalSts;
/**
 * Actual Period
 * @author nilcy
 */
@Entity
@Table(name = "actual_period", uniqueConstraints = { @UniqueConstraint(columnNames = { "activity_id", "period_id",
        "worker_id" }) })
public class ActualPeriod extends TrackEntity {
    /** S/N */
    private static final long serialVersionUID = 2080877769423615703L;
    /** Activity */
    private Activity activity;
    /** Period */
    private Period period;
    /** Person */
    private Person person;
    /** Approval Status */
    private ApprovalSts sts = ApprovalSts.ENTRY;
    /** ActualPeriod Works */
    private List<ActualWork> actualWorks = new ArrayList<ActualWork>(0);
    /** ActualPeriod Expenses */
    private List<ActualExpense> actualExpenses = new ArrayList<ActualExpense>(0);
    /**
     * Constructor
     */
    public ActualPeriod() {
        // NOP
    }
    /**
     * @return Activity
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "activity_id", referencedColumnName = "id", nullable = false, insertable = true, updatable = true)
    public Activity getActivity() {
        return this.activity;
    }
    /**
     * @param aActivity Activity
     */
    public void setActivity(Activity aActivity) {
        this.activity = aActivity;
    }
    /**
     * @return Period
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "period_id", referencedColumnName = "id", nullable = false, insertable = true, updatable = true)
    public Period getPeriod() {
        return this.period;
    }
    /**
     * @param aPeriod Period
     */
    public void setPeriod(Period aPeriod) {
        this.period = aPeriod;
    }
    /**
     * @return Person
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "worker_id", referencedColumnName = "id", nullable = false, insertable = true, updatable = true)
    public Person getWorker() {
        return this.person;
    }
    /**
     * @param aPerson Person
     */
    public void setWorker(Person aPerson) {
        this.person = aPerson;
    }
    /**
     * @return Approval Status
     */
    @Column(name = "sts", nullable = true, insertable = true, updatable = true)
    @Enumerated(EnumType.STRING)
    public ApprovalSts getSts() {
        return this.sts;
    }
    /**
     * @param aSts Approval Status
     */
    public void setSts(ApprovalSts aSts) {
        this.sts = aSts;
    }
    /**
     * @return ActualPeriod Works
     */
    @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.LAZY, mappedBy = "actualPeriod")
    public List<ActualWork> getActualWorks() {
        return this.actualWorks;
    }
    /**
     * @param aActualWorks ActualPeriod Works
     */
    public void setActualWorks(List<ActualWork> aActualWorks) {
        this.actualWorks = aActualWorks;
    }
    /**
     * @return ActualPeriod Expenses
     */
    @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.LAZY, mappedBy = "actualPeriod")
    public List<ActualExpense> getActualExpenses() {
        return this.actualExpenses;
    }
    /**
     * @param aActualExpenses ActualPeriod Expenses
     */
    public void setActualExpenses(List<ActualExpense> aActualExpenses) {
        this.actualExpenses = aActualExpenses;
    }
}
