// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: ActualExpense.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp.mng;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import kuzumeji.entity.Person;
import kuzumeji.entity.TrackEntity;
import kuzumeji.entity.def.ExpenseCat;
import org.hibernate.validator.Length;
/**
 * ActualPeriod Expense
 * @author nilcy
 */
@Entity
@Table(name = "actual_expense", uniqueConstraints = {})
public class ActualExpense extends TrackEntity {
    /** S/N */
    private static final long serialVersionUID = -8145138917930164715L;
    /** Actual Period */
    private ActualPeriod actualPeriod;
    /** Expense Category */
    private ExpenseCat cat = ExpenseCat.WORKER;
    /** Pay Date */
    private Date payDate;
    /** Expense Item */
    private String item;
    /** Expense Name */
    private String name;
    /** Text */
    private String text;
    /** Cost */
    private Long cost;
    /** Note */
    private String note;
    /** Partner */
    private Person partner;
    /**
     * Constructor
     */
    public ActualExpense() {
        // NOP
    }
    /**
     * @return ActualPeriod
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "actual_period_id", referencedColumnName = "id", nullable = false, insertable = true, updatable = true)
    public ActualPeriod getActualPeriod() {
        return this.actualPeriod;
    }
    /**
     * @param aActualPeriod Actual Period
     */
    public void setActualPeriod(ActualPeriod aActualPeriod) {
        this.actualPeriod = aActualPeriod;
    }
    /**
     * @return Expense Category
     */
    @Column(name = "cat", nullable = false, insertable = true, updatable = true)
    @Enumerated(EnumType.STRING)
    public ExpenseCat getCat() {
        return this.cat;
    }
    /**
     * @param aCat Expense Category
     */
    public void setCat(ExpenseCat aCat) {
        this.cat = aCat;
    }
    /**
     * @return Pay Date
     */
    @Column(name = "pay_date", nullable = false, insertable = true, updatable = true)
    @Basic
    @Temporal(TemporalType.DATE)
    public Date getPayDate() {
        return this.payDate;
    }
    /**
     * @param aPayDate Pay Date
     */
    public void setPayDate(Date aPayDate) {
        this.payDate = aPayDate;
    }
    /**
     * @return Expense Item
     */
    @Column(name = "item", nullable = false, insertable = true, updatable = true)
    public String getItem() {
        return this.item;
    }
    /**
     * @param aItem Expense Item
     */
    public void setItem(String aItem) {
        this.item = aItem;
    }
    /**
     * @return Expense Name
     */
    @Column(name = "name", nullable = true, insertable = true, updatable = true)
    @Length(max = 100)
    public String getName() {
        return this.name;
    }
    /**
     * @param aCostName Expense Name
     */
    public void setName(String aCostName) {
        this.name = aCostName;
    }
    /**
     * @return Text
     */
    @Column(name = "text", nullable = true, insertable = true, updatable = true)
    @Length(max = 100)
    public String getText() {
        return this.text;
    }
    /**
     * @param aText Text
     */
    public void setText(String aText) {
        this.text = aText;
    }
    /**
     * @return Cost
     */
    @Column(name = "cost", nullable = false, insertable = true, updatable = true)
    public Long getCost() {
        return this.cost;
    }
    /**
     * @param aCost Cost
     */
    public void setCost(Long aCost) {
        this.cost = aCost;
    }
    /**
     * @return Note
     */
    @Column(name = "note", nullable = true, insertable = true, updatable = true)
    @Length(max = 1000)
    public String getNote() {
        return this.note;
    }
    /**
     * @param aCostNote Note
     */
    public void setNote(String aCostNote) {
        this.note = aCostNote;
    }
    /**
     * @return Partner
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "partner_id", referencedColumnName = "id", nullable = true, insertable = true, updatable = true)
    public Person getPartner() {
        return this.partner;
    }
    /**
     * @param aPartner Partner
     */
    public void setPartner(Person aPartner) {
        this.partner = aPartner;
    }
}
