// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.networth;
import kuzumeji.entity.TrackEntity;
import kuzumeji.entity.erp.fin.bs.BalanceSheet;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
/**
 * Net Worth
 * @author nilcy
 */
@Entity
@Table(name = "bs_net_worth")
public class NetWorth extends TrackEntity {
    /** S/N */
    private static final long serialVersionUID = -236510401928594307L;
    /** Balance Sheet */
    private BalanceSheet balanceSheet;
    /** Shareholder's Equity */
    private ShareholdersEquity shareholdersEquity;
    /** Assessment Convert Difference */
    private AssessmentConvertDifference assessmentConvertDifference;
    /** Subscription rights to shares */
    private Long subscriptionRightsToShares;
    /** Minority interests */
    private Long minorityInterests;
    /**
     * getter for Balance Sheet
     * @return Balance Sheet
     */
    @OneToOne(optional = false)
    @PrimaryKeyJoinColumn(name = "id", referencedColumnName = "id")
    public BalanceSheet getBalanceSheet() {
        return this.balanceSheet;
    }
    /**
     * setter for Balance Sheet
     * @param aBalanceSheet Balance Sheet
     */
    public void setBalanceSheet(BalanceSheet aBalanceSheet) {
        this.balanceSheet = aBalanceSheet;
    }
    /**
     * getter for Shareholder's Equity
     * @return Shareholder's Equity
     */
    @Embedded
    public ShareholdersEquity getShareholdersEquity() {
        return this.shareholdersEquity;
    }
    /**
     * setter for Shareholder's Equity
     * @param aShareholdersEquity Shareholder's Equity
     */
    public void setShareholdersEquity(ShareholdersEquity aShareholdersEquity) {
        this.shareholdersEquity = aShareholdersEquity;
    }
    /**
     * getter for Assessment Convert Difference
     * @return Assessment Convert Difference
     */
    @Embedded
    public AssessmentConvertDifference getAssessmentConvertDifference() {
        return this.assessmentConvertDifference;
    }
    /**
     * setter for Assessment Convert Difference
     * @param aAssessmentConvertDifference Assessment Convert Difference
     */
    public void setAssessmentConvertDifference(AssessmentConvertDifference aAssessmentConvertDifference) {
        this.assessmentConvertDifference = aAssessmentConvertDifference;
    }
    /**
     * getter for Subscription rights to shares
     * @return Subscription rights to shares
     */
    @Column(name = "subscription_rights_to_shares", nullable = true, insertable = true, updatable = true)
    public Long getSubscriptionRightsToShares() {
        return this.subscriptionRightsToShares;
    }
    /**
     * setter for Subscription rights to shares
     * @param aSubscriptionRightsToShares Subscription rights to shares
     */
    public void setSubscriptionRightsToShares(Long aSubscriptionRightsToShares) {
        this.subscriptionRightsToShares = aSubscriptionRightsToShares;
    }
    /**
     * getter for Minority interests
     * @return Minority interests
     */
    @Column(name = "minority_interests", nullable = true, insertable = true, updatable = true)
    public Long getMinorityInterests() {
        return this.minorityInterests;
    }
    /**
     * setter for Minority interests
     * @param aMinorityInterests Minority interests
     */
    public void setMinorityInterests(Long aMinorityInterests) {
        this.minorityInterests = aMinorityInterests;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return ((this.shareholdersEquity == null) ? 0L : this.shareholdersEquity.sum())
                + ((this.assessmentConvertDifference == null) ? 0L : this.assessmentConvertDifference.sum())
                + nvl(this.subscriptionRightsToShares) + nvl(this.minorityInterests);
    }
    /**
     * nvl
     * @param aNum number
     * @return nvl(aNum)
     */
    @Transient
    private long nvl(Long aNum) {
        return (aNum == null) ? 0L : aNum;
    }
}
