// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.asset;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
/**
 * Inventories
 * @author nilcy
 */
@Embeddable
public class Inventories implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = 664930010511265081L;
    /** Merchandise */
    private Long merchandise;
    /** Finished Goods */
    private Long finishedGoods;
    /** Half-Finished Goods */
    private Long halfFinishedGoods;
    /** Raw Materials */
    private Long rawMaterials;
    /** Work in process */
    private Long workInProcess;
    /** Stores */
    private Long stores;
    /**
     * getter for Merchandise
     * @return Merchandise
     */
    @Column(name = "merchandise", nullable = true, insertable = true, updatable = true)
    public Long getMerchandise() {
        return this.merchandise;
    }
    /**
     * setter for Merchandise
     * @param aMerchandise Merchandise
     */
    public void setMerchandise(Long aMerchandise) {
        this.merchandise = aMerchandise;
    }
    /**
     * getter for Finished Goods
     * @return Finished Goods
     */
    @Column(name = "finished_goods", nullable = true, insertable = true, updatable = true)
    public Long getFinishedGoods() {
        return this.finishedGoods;
    }
    /**
     * setter for Finished Goods
     * @param aFinishedGoods Finished Goods
     */
    public void setFinishedGoods(Long aFinishedGoods) {
        this.finishedGoods = aFinishedGoods;
    }
    /**
     * getter for Half-Finished Goods
     * @return Half-Finished Goods
     */
    @Column(name = "half_finished_goods", nullable = true, insertable = true, updatable = true)
    public Long getHalfFinishedGoods() {
        return this.halfFinishedGoods;
    }
    /**
     * setter for Half-Finished Goods
     * @param aHalfFinishedGoods Half-Finished Goods
     */
    public void setHalfFinishedGoods(Long aHalfFinishedGoods) {
        this.halfFinishedGoods = aHalfFinishedGoods;
    }
    /**
     * getter for Raw Materials
     * @return Raw Materials
     */
    @Column(name = "raw_materials", nullable = true, insertable = true, updatable = true)
    public Long getRawMaterials() {
        return this.rawMaterials;
    }
    /**
     * setter for Raw Materials
     * @param aRawMaterials Raw Materials
     */
    public void setRawMaterials(Long aRawMaterials) {
        this.rawMaterials = aRawMaterials;
    }
    /**
     * getter for Work in process
     * @return Work in process
     */
    @Column(name = "work_in_process", nullable = true, insertable = true, updatable = true)
    public Long getWorkInProcess() {
        return this.workInProcess;
    }
    /**
     * setter for Work in process
     * @param aWorkInProcess Work in process
     */
    public void setWorkInProcess(Long aWorkInProcess) {
        this.workInProcess = aWorkInProcess;
    }
    /**
     * getter for Stores
     * @return Stores
     */
    @Column(name = "stores", nullable = true, insertable = true, updatable = true)
    public Long getStores() {
        return this.stores;
    }
    /**
     * setter for Stores
     * @param aStores Stores
     */
    public void setStores(Long aStores) {
        this.stores = aStores;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return nvl(this.merchandise) + nvl(this.finishedGoods) + nvl(this.halfFinishedGoods)
	    + nvl(this.rawMaterials) + nvl(this.workInProcess) + nvl(this.stores);
    }
    /**
     * nvl
     * @param aNum number
     * @return nvl(aNum)
     */
    @Transient
    private long nvl(Long aNum) {
        return (aNum == null) ? 0L : aNum;
    }
}
