// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.asset;
import java.io.Serializable;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Transient;
/**
 * Fixed Asset
 * @author nilcy
 */
@Embeddable
public class FixedAsset implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = -1526584574123852869L;
    /** Tangible Assets */
    private TangibleAssets tangibleAssets;
    /** Intangible Assets */
    private IntangibleAssets intangibleAssets;
    /** Investments and other assets */
    private InvestmentsAndOtherAssets investmentsAndOtherAssets;
    /**
     * getter for Tangible Assets
     * @return Tangible Assets
     */
    @Embedded
    public TangibleAssets getTangibleAssets() {
        return this.tangibleAssets;
    }
    /**
     * setter for Tangible Assets
     * @param aTangibleAssets Tangible Assets
     */
    public void setTangibleAssets(TangibleAssets aTangibleAssets) {
        this.tangibleAssets = aTangibleAssets;
    }
    /**
     * getter for Intangible Assets
     * @return Intangible Assets
     */
    @Embedded
    public IntangibleAssets getIntangibleAssets() {
        return this.intangibleAssets;
    }
    /**
     * setter for Intangible Assets
     * @param aIntangibleAssets Intangible Assets
     */
    public void setIntangibleAssets(IntangibleAssets aIntangibleAssets) {
        this.intangibleAssets = aIntangibleAssets;
    }
    /**
     * getter for Investments and other assets
     * @return Investments and other assets
     */
    @Embedded
    public InvestmentsAndOtherAssets getInvestmentsAndOtherAssets() {
        return this.investmentsAndOtherAssets;
    }
    /**
     * setter for Investments and other assets
     * @param aInvestmentsAndOtherAssets Investments and other assets
     */
    public void setInvestmentsAndOtherAssets(InvestmentsAndOtherAssets aInvestmentsAndOtherAssets) {
        this.investmentsAndOtherAssets = aInvestmentsAndOtherAssets;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return ((this.tangibleAssets == null) ? 0L : this.tangibleAssets.sum())
                + ((this.intangibleAssets == null) ? 0L : this.intangibleAssets.sum())
                + ((this.investmentsAndOtherAssets == null) ? 0L : this.investmentsAndOtherAssets.sum());
    }
}
