// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.asset;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
/**
 * Deferred Assets
 * @author nilcy
 */
@Embeddable
public class DeferredAsset implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = -8257034090938780388L;
    /** inaugural expenses */
    private Long inaugural;
    /** business commencement expense */
    private Long businessCommencement;
    /** research and development expenditures */
    private Long researchAndDevelopment;
    /** share issuing expense */
    private Long shareIssuing;
    /** bond expense */
    private Long bond;
    /**
     * getter for inaugural expenses
     * @return inaugural expenses
     */
    @Column(name = "inaugural", nullable = true, insertable = true, updatable = true)
    public Long getInaugural() {
        return this.inaugural;
    }
    /**
     * setter for inaugural expenses
     * @param aInaugural inaugural expenses
     */
    public void setInaugural(Long aInaugural) {
        this.inaugural = aInaugural;
    }
    /**
     * getter for business commencement expense
     * @return business commencement expense
     */
    @Column(name = "business_commencement", nullable = true, insertable = true, updatable = true)
    public Long getBusinessCommencement() {
        return this.businessCommencement;
    }
    /**
     * setter for business commencement expense
     * @param aBusinessCommencement business commencement expense
     */
    public void setBusinessCommencement(Long aBusinessCommencement) {
        this.businessCommencement = aBusinessCommencement;
    }
    /**
     * getter for research and development expenditures
     * @return research and development expenditures
     */
    @Column(name = "research_and_development", nullable = true, insertable = true, updatable = true)
    public Long getResearchAndDevelopment() {
        return this.researchAndDevelopment;
    }
    /**
     * setter for research and development expenditures
     * @param aResearchAndDevelopment research and development expenditures
     */
    public void setResearchAndDevelopment(Long aResearchAndDevelopment) {
        this.researchAndDevelopment = aResearchAndDevelopment;
    }
    /**
     * getter for share issuing expense
     * @return share issuing expense
     */
    @Column(name = "share_issuing", nullable = true, insertable = true, updatable = true)
    public Long getShareIssuing() {
        return this.shareIssuing;
    }
    /**
     * setter for share issuing expense
     * @param aShareIssuing share issuing expense
     */
    public void setShareIssuing(Long aShareIssuing) {
        this.shareIssuing = aShareIssuing;
    }
    /**
     * getter for bond expense
     * @return bond expense
     */
    @Column(name = "bond", nullable = true, insertable = true, updatable = true)
    public Long getBond() {
        return this.bond;
    }
    /**
     * setter for bond expense
     * @param aBond bond expense
     */
    public void setBond(Long aBond) {
        this.bond = aBond;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return nvl(this.inaugural) + nvl(this.businessCommencement) + nvl(this.researchAndDevelopment)
                + nvl(this.shareIssuing) + nvl(this.bond);
    }
    /**
     * nvl
     * @param aNum number
     * @return nvl(aNum)
     */
    @Transient
    private long nvl(Long aNum) {
        return (aNum == null) ? 0L : aNum;
    }
}
