// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.asset;
import java.io.Serializable;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Transient;
/**
 * Checking Account
 * @author nilcy
 */
@Embeddable
public class CheckingAccount implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = -2283478328510412778L;
    /** Receivables */
    private Receivables receivables;
    /**
     * getter for Receivables
     * @return Receivables
     */
    @Embedded
    public Receivables getReceivables() {
        return this.receivables;
    }
    /**
     * setter for Receivables
     * @param aReceivables Receivables
     */
    public void setReceivables(Receivables aReceivables) {
        this.receivables = aReceivables;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return (this.receivables == null) ? 0L : this.receivables.sum();
    }
}
