// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: Person.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp.fin.bs;
import kuzumeji.entity.TrackEntity;
import kuzumeji.entity.erp.fin.bs.asset.Asset;
import kuzumeji.entity.erp.fin.bs.liability.Liability;
import kuzumeji.entity.erp.fin.bs.networth.NetWorth;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
/**
 * Balance Sheet
 * @author nilcy
 */
@Entity
@Table(name = "balance_sheet")
public class BalanceSheet extends TrackEntity {
    /** S/N */
    private static final long serialVersionUID = -213659584412322620L;
    /** Asset */
    private Asset asset;
    /** Liability */
    private Liability liability;
    /** NetWorth */
    private NetWorth netWorth;
    /**
     * getter for asset
     * @return asset
     */
    @OneToOne(cascade = CascadeType.REMOVE)
    @PrimaryKeyJoinColumn(name = "id", referencedColumnName = "id")
    public Asset getAsset() {
        return this.asset;
    }
    /**
     * setter for asset
     * @param aAsset asset
     */
    public void setAsset(Asset aAsset) {
        this.asset = aAsset;
    }
    /**
     * getter for liability
     * @return liability
     */
    @OneToOne(cascade = CascadeType.REMOVE)
    @PrimaryKeyJoinColumn(name = "id", referencedColumnName = "id")
    public Liability getLiability() {
        return this.liability;
    }
    /**
     * setter for liability
     * @param aLiability liability
     */
    public void setLiability(Liability aLiability) {
        this.liability = aLiability;
    }
    /**
     * getter for netWorth
     * @return netWorth
     */
    @OneToOne(cascade = CascadeType.REMOVE)
    @PrimaryKeyJoinColumn(name = "id", referencedColumnName = "id")
    public NetWorth getNetWorth() {
        return this.netWorth;
    }
    /**
     * setter for netWorth
     * @param aNetWorth netWorth
     */
    public void setNetWorth(NetWorth aNetWorth) {
        this.netWorth = aNetWorth;
    }
}
