// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: Team.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import kuzumeji.entity.Party;
import kuzumeji.entity.erp.mng.Activity;
import kuzumeji.entity.erp.mng.WorkerCost;
/**
 * Team
 * @author nilcy
 */
@Entity
@Table(name = "team")
@Inheritance(strategy = InheritanceType.JOINED)
public class Team extends Party {
    /** S/N */
    private static final long serialVersionUID = 7565624595956332265L;
    /** Worker List */
    private List<Worker> workers = new ArrayList<Worker>(0);
    /** WorkerCost List */
    private List<WorkerCost> workerCosts = new ArrayList<WorkerCost>(0);
    /** Activity List */
    private List<Activity> activities = new ArrayList<Activity>(0);
    /**
     * Constructor
     */
    public Team() {
        // NOP
    }
    /**
     * @return Worker List
     */
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "team")
    public List<Worker> getWorkers() {
        return this.workers;
    }
    /**
     * @param aWorkers Worker List
     */
    public void setWorkers(List<Worker> aWorkers) {
        this.workers = aWorkers;
    }
    /**
     * @return WorkerCost List
     */
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "team")
    public List<WorkerCost> getWorkerCosts() {
        return this.workerCosts;
    }
    /**
     * @param aWorkerCosts WorkerCost List
     */
    public void setWorkerCosts(List<WorkerCost> aWorkerCosts) {
        this.workerCosts = aWorkerCosts;
    }
    /**
     * @return Activity List
     */
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "team")
    public List<Activity> getActivities() {
        return this.activities;
    }
    /**
     * @param aActivities Activity List
     */
    public void setActivities(List<Activity> aActivities) {
        this.activities = aActivities;
    }
}
