// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: Customer.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import kuzumeji.entity.Party;
import kuzumeji.entity.erp.mng.Activity;
/**
 * Team
 * @author nilcy
 */
@Entity
@Table(name = "customer")
@Inheritance(strategy = InheritanceType.JOINED)
public class Customer extends Party {
    /** S/N */
    private static final long serialVersionUID = 7236865307422677627L;
    /** Activity List */
    private List<Activity> activities = new ArrayList<Activity>(0);
    /**
     * Constructor
     */
    public Customer() {
        // NOP
    }
    /**
     * @return Activity List
     */
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "customer")
    public List<Activity> getActivities() {
        return this.activities;
    }
    /**
     * @param aActivities Activity List
     */
    public void setActivities(List<Activity> aActivities) {
        this.activities = aActivities;
    }
}
