// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: ResourceEntity.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
/**
 * ResourceEntity
 * @author nilcy
 */
@MappedSuperclass
public class ResourceEntity extends TrackEntity {
    /** S/N */
    private static final long serialVersionUID = 5134252804090682697L;
    /** Creatable */
    private boolean creatable = true;
    /** Readable */
    private boolean readable = true;
    /** Constructor */
    public ResourceEntity() {
        // NOP
    }
    /**
     * getter for Creatable
     * @return creatable Creatable
     */
    @Column(name = "creatable", nullable = false)
    public boolean isCreatable() {
        return this.creatable;
    }
    /**
     * setter for Creatable
     * @param aCreatable Creatable
     */
    public void setCreatable(boolean aCreatable) {
        this.creatable = aCreatable;
    }
    /**
     * getter for Readable
     * @return readable Readable
     */
    @Column(name = "readable", nullable = false)
    public boolean isReadable() {
        return this.readable;
    }
    /**
     * setter for Readable
     * @param aReadable Readable
     */
    public void setReadable(boolean aReadable) {
        this.readable = aReadable;
    }
}
