// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: BaseEntity.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity;
import kuzumeji.entity.def.ActivityRole;
import kuzumeji.entity.def.ApprovalSts;
import kuzumeji.entity.def.DateCat;
import kuzumeji.entity.def.ExpenseCat;
import kuzumeji.util.DateUtil;
import java.util.Date;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
/**
 * Factories
 * @author nilcy
 */
@Name("factories")
public class Factories {
    /**
     * getter for activityRoles
     * @return activityRoles
     */
    @Factory("activityRoles")
    public ActivityRole[] getActivityRoles() {
        return ActivityRole.values();
    }
    /**
     * getter for approvalStses
     * @return approvalStses
     */
    @Factory("approvalStses")
    public ApprovalSts[] getApprovalStses() {
        return ApprovalSts.values();
    }
    /**
     * getter for dateCats
     * @return dateCats
     */
    @Factory("dateCats")
    public DateCat[] getDateCats() {
        return DateCat.values();
    }
    /**
     * getter for expenseCats
     * @return expenseCats
     */
    @Factory("expenseCats")
    public ExpenseCat[] getExpenseCats() {
        return ExpenseCat.values();
    }
    /**
     * getter for this Month
     * @return this Month
     */
    @Factory("thisMonth")
    public Date getThisMonth() {
        return DateUtil.getFirstDateOfThisMonth();
    }
}
