package kuzumeji.dto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kuzumeji.entity.Person;
import kuzumeji.entity.erp.mng.ActualWork;
import kuzumeji.util.DateUtil;
import org.apache.commons.collections.CollectionUtils;
/**
 * WorkPeriod
 * @author nilcy
 */
public class WorkPeriod implements Serializable {
    /** S/N */
    private static final long serialVersionUID = -8569665973882005810L;
    /** Person */
    private Person person;
    /** From Date */
    private Date fromDate;
    /** To Date */
    private Date toDate;
    /** WorkDate List */
    private List<WorkDate> workDates = new ArrayList<WorkDate>(0);
    /**
     * private CONSTRUCTOR
     * @param aPerson
     * @param aWorkDates
     */
    public WorkPeriod(Person aPerson, List<WorkDate> aWorkDates) {
        this.person = aPerson;
        this.fromDate = aWorkDates.get(0).getDate();
        this.toDate = aWorkDates.get(aWorkDates.size() - 1).getDate();
        this.workDates = Collections.unmodifiableList(aWorkDates);
    }
    /**
     * public CONSTRUCTOR
     * @param aPerson
     * @param aFromDate
     * @param aToDate
     * @param aActualWorks
     */
    public WorkPeriod(Person aPerson, Date aFromDate, Date aToDate, List<ActualWork> aActualWorks) {
        this.person = aPerson;
        this.fromDate = aFromDate;
        this.toDate = aToDate;
        Map<Date, List<ActualWork>> map = new HashMap<Date, List<ActualWork>>(0);
        if (aActualWorks != null) {
            for (ActualWork actualWork : aActualWorks) {
                Date d = actualWork.getWorkDate();
                if (!map.containsKey(d)) {
                    map.put(d, new ArrayList<ActualWork>(0));
                }
                map.get(d).add(actualWork);
            }
        }
        List<WorkDate> tmpDates = new ArrayList<WorkDate>(0);
        for (Date date : DateUtil.getDatesByRange(aFromDate, aToDate)) {
            tmpDates.add(new WorkDate(aPerson, date, map.get(date)));
        }
        this.workDates = Collections.unmodifiableList(tmpDates);
    }
    /**
     * @return Person
     */
    public Person getWorker() {
        return this.person;
    }
    /**
     * @return From Date
     */
    public Date getFromDate() {
        return this.fromDate;
    }
    /**
     * @return To Date
     */
    public Date getToDate() {
        return this.toDate;
    }
    /**
     * @return workDates
     */
    public List<WorkDate> getWorkDates() {
        return this.workDates;
    }
    /**
     * @return WorkPeriod List by Week
     */
    public List<WorkPeriod> splitByWeek() {
        List<WorkPeriod> tmpPeriods = new ArrayList<WorkPeriod>(0);
        List<WorkDate> tmpDates = new ArrayList<WorkDate>(0);
        for (WorkDate workDate : this.workDates) {
            if (CollectionUtils.isEmpty(tmpDates) && isSunday(workDate.getDate())) {
                WorkPeriod workPeriod = new WorkPeriod(this.person, tmpDates);
                tmpPeriods.add(workPeriod);
                tmpDates = new ArrayList<WorkDate>(0);
            }
            tmpDates.add(workDate);
        }
        if (!CollectionUtils.isEmpty(tmpDates)) {
            WorkPeriod workPeriod = new WorkPeriod(this.person, tmpDates);
            tmpPeriods.add(workPeriod);
        }
        return tmpPeriods;
    }
    /**
     * @param aDate Date
     * @return is Sunday
     */
    private boolean isSunday(Date aDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(aDate);
        return cal.get(Calendar.DAY_OF_MONTH) == Calendar.SUNDAY;
    }
}
