package kuzumeji.async;
import kuzumeji.entity.Contact;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.annotations.async.Duration;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.Renderer;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
/**
 * @author nilcy
 */
@Name("asyncMailProcessor")
@AutoCreate
public class AsyncMailProcessor {
    /** LOG */
    private static final LogProvider LOG = Logging.getLogProvider(AsyncMailProcessor.class);
    /**
     * scheduleSend
     * @param aDelay
     * @param aContact
     * @param aUrl 
     */
    @Asynchronous
    public void send(@Duration long aDelay, Contact aContact, String aUrl) {
        try {
            Contexts.getEventContext().set("contact", aContact);
            Renderer.instance().render(aUrl);
        } catch (Exception e) {
            LOG.error("Error scheduling send #0", e);
        }
    }
}
