// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: NewsList.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.action.list.sys;
import kuzumeji.action.list.BaseEntityQuery;
import kuzumeji.entity.sys.Notify;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
/**
 * NotifyList
 * @author nilcy
 */
@Name("notifyList")
@Scope(ScopeType.CONVERSATION)
public class NotifyList extends BaseEntityQuery<Notify> {
    /** S/N */
    private static final long serialVersionUID = 8701470585292145626L;
    /** EJB-QL */
    private static final String EJBQL = "select notify from Notify notify";
    /** RESTRICTIONS */
    private static final String[] RESTRICTIONS = { "notify.user like concat(#{notifyList_notify.user},'%')",
            "notify.text like concat(#{notifyList_notify.text},'%')", "notify.title like concat(#{notifyList_notify.title},'%')", };
    /** FILTER */
    @In(value = "notifyList_notify", scope = ScopeType.SESSION, required = false)
    @Out(value = "notifyList_notify", scope = ScopeType.SESSION, required = false)
    private Notify notify;
    /** CONSTRUCTOR */
    public NotifyList() {
        super(EJBQL, RESTRICTIONS);
        setOrder("notify.id desc");
    }
    /**
     * @return FILTER
     */
    public Notify getNotify() {
        return this.notify;
    }
    @Override
    public void validate() {
        super.validate();
        if (this.notify == null) {
            this.notify = new Notify();
        }
    }
}
