// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: ConfigList.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.action.list.sys;
import kuzumeji.action.list.BaseEntityQuery;
import kuzumeji.entity.sys.Config;
import org.jboss.seam.annotations.Name;
/**
 * Config List
 * @author nilcy
 */
@Name("configList")
public class ConfigList extends BaseEntityQuery<Config> {
    /** S/N */
    private static final long serialVersionUID = 1503453611248983708L;
    /** EJB-QL */
    private static final String EJBQL = "select config from Config config";
    /** RESTRICTIONS */
    private static final String[] RESTRICTIONS = { "(config.cat) like (concat(#{configList.config.cat},'%'))",
            "(config.key) like (concat(#{configList.config.key},'%'))",
            "(config.val) like (concat(#{configList.config.val},'%'))", };
    /** FILTER */
    private Config config = new Config();
    /** CONSTRUCTOR */
    public ConfigList() {
        super(EJBQL, RESTRICTIONS);
    }
    /**
     * @return FILTER
     */
    public Config getConfig() {
        return this.config;
    }
}
