// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: CalendarList.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.action.list.sys;
import kuzumeji.action.list.BaseEntityQuery;
import kuzumeji.entity.sys.Calendar;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
/**
 * Calendar List
 * @author nilcy
 */
@Name("calendarList")
@Scope(ScopeType.CONVERSATION)
public class CalendarList extends BaseEntityQuery<Calendar> {
    /** S/N */
    private static final long serialVersionUID = 3465868930538794841L;
    /** EJB-QL */
    private static final String EJBQL = "select calendar from Calendar calendar";
    /** RESTRICTIONS */
    private static final String[] RESTRICTIONS = { "calendar.date >= #{thisMonth}",
            "calendar.cat = #{calendarList_calendar.cat}",
            "(calendar.name) like (concat(#{calendarList_calendar.name},'%'))",
            "(calendar.text) like (concat(#{calendarList_calendar.text},'%'))", };
    /** FILTER */
    @In(value = "calendarList_calendar", scope = ScopeType.SESSION, required = false)
    @Out(value = "calendarList_calendar", scope = ScopeType.SESSION, required = false)
    private Calendar calendar = new Calendar();
    /** CONSTRUCTOR */
    public CalendarList() {
        super(EJBQL, RESTRICTIONS);
    }
    /**
     * @return FILTER
     */
    public Calendar getCalendar() {
        return this.calendar;
    }
    @Override
    public void validate() {
        super.validate();
        if (this.calendar == null) {
            this.calendar = new Calendar();
        }
    }
}
