// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: WorkerList.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.action.list.erp;
import kuzumeji.action.list.BaseEntityQuery;
import kuzumeji.entity.erp.Worker;
import org.jboss.seam.annotations.Name;
/**
 * Worker List
 * @author nilcy
 */
@Name("workerList")
public class WorkerList extends BaseEntityQuery<Worker> {
    /** S/N */
    private static final long serialVersionUID = -6472803803342422367L;
    /** EJB-QL */
    private static final String EJBQL = "select worker from Worker worker";
    /** RESTRICTIONS */
    private static final String[] RESTRICTIONS = {
            "(worker.code) like (concat(#{workerList.worker.code},'%'))",
            "(worker.name) like (concat(#{workerList.worker.name},'%'))",
            "(worker.nick) like (concat(#{workerList.worker.nick},'%'))",
            "(worker.note) like (concat(#{workerList.worker.note},'%'))",
            "(worker.contact.zip)   like (concat(#{workerList.worker.contact.zip},'%'))",
            "(worker.contact.addr1)  like (concat(#{workerList.worker.contact.addr1},'%'))",
            "(worker.contact.addr2) like (concat(#{workerList.worker.contact.addr2},'%'))",
            "(worker.contact.tel)   like (concat(#{workerList.worker.contact.tel},'%'))",
            "(worker.contact.mail)  like (concat(#{workerList.worker.contact.mail},'%'))",
            "(worker.contact.web)   like (concat(#{workerList.worker.contact.web},'%'))", };
    /** FILTER */
    private Worker worker = new Worker();
    /** CONSTRUCTOR */
    public WorkerList() {
        super(EJBQL, RESTRICTIONS);
    }
    /**
     * @return FILTER
     */
    public Worker getWorker() {
        return this.worker;
    }
}
