// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: TeamList.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.action.list.erp;
import kuzumeji.action.list.BaseEntityQuery;
import kuzumeji.entity.erp.Team;
import org.jboss.seam.annotations.Name;
/**
 * Team List
 * @author nilcy
 */
@Name("teamList")
public class TeamList extends BaseEntityQuery<Team> {
    /** S/N */
    private static final long serialVersionUID = -8106555122194771341L;
    /** EJB-QL */
    private static final String EJBQL = "select team from Team team";
    /** RESTRICTIONS */
    private static final String[] RESTRICTIONS = { "(team.code) like (concat(#{teamList.team.code},'%'))",
            "(team.name) like (concat(#{teamList.team.name},'%'))",
            "(team.nick) like (concat(#{teamList.team.nick},'%'))",
            "(team.note) like (concat(#{teamList.team.note},'%'))",
            "(team.contact.zip)   like (concat(#{teamList.team.contact.zip},'%'))", 
            "(team.contact.addr1)  like (concat(#{teamList.team.contact.addr1},'%'))",
            "(team.contact.addr2) like (concat(#{teamList.team.contact.addr2},'%'))",
            "(team.contact.tel)   like (concat(#{teamList.team.contact.tel},'%'))",
            "(team.contact.mail)  like (concat(#{teamList.team.contact.mail},'%'))",
            "(team.contact.web)   like (concat(#{teamList.team.contact.web},'%'))",};
    /** FILTER */
    private Team team = new Team();
    /** CONSTRUCTOR */
    public TeamList() {
        super(EJBQL, RESTRICTIONS);
    }
    /**
     * @return FILTER
     */
    public Team getTeam() {
        return this.team;
    }
}
