package kuzumeji.action.home.erp.mng;
import java.util.ArrayList;
import java.util.List;
import kuzumeji.action.home.BaseEntityHome;
import kuzumeji.action.home.erp.WorkerHome;
import kuzumeji.entity.Person;
import kuzumeji.entity.erp.mng.Activity;
import kuzumeji.entity.erp.mng.PlanWork;
import kuzumeji.entity.erp.mng.PlanWorkDetail;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
@Name("planWorkHome")
public class PlanWorkHome extends BaseEntityHome<PlanWork> {
    @In(create = true)
    ActivityHome activityHome;
    @In(create = true)
    WorkerHome workerHome;
    public void setPlanWorkId(Long id) {
        setId(id);
    }
    public Long getPlanWorkId() {
        return (Long) getId();
    }
    @Override
    protected PlanWork createInstance() {
        PlanWork planWork = new PlanWork();
        return planWork;
    }
    public void load() {
        if (isIdDefined()) {
            wire();
        }
    }
    public void wire() {
        getInstance();
        Activity activity = activityHome.getDefinedInstance();
        if (activity != null) {
            getInstance().setActivity(activity);
        }
        Person person = workerHome.getDefinedInstance();
        if (person != null) {
            getInstance().setWorker(person);
        }
    }
    public boolean isWired() {
        if (getInstance().getActivity() == null) return false;
        if (getInstance().getWorker() == null) return false;
        return true;
    }
    public PlanWork getDefinedInstance() {
        return isIdDefined() ? getInstance() : null;
    }
    public List<PlanWorkDetail> getPlanWorkDetails() {
        return getInstance() == null ? null : new ArrayList<PlanWorkDetail>(getInstance().getPlanWorkDetails());
    }
}
