package kuzumeji.action.home.erp.mng;
import java.util.ArrayList;
import java.util.List;
import kuzumeji.action.home.BaseEntityHome;
import kuzumeji.entity.erp.mng.Activity;
import kuzumeji.entity.erp.mng.PlanExpense;
import kuzumeji.entity.erp.mng.PlanExpenseDetail;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
@Name("planExpenseHome")
public class PlanExpenseHome extends BaseEntityHome<PlanExpense> {
    @In(create = true)
    ActivityHome activityHome;
    public void setPlanExpenseId(Long id) {
        setId(id);
    }
    public Long getPlanExpenseId() {
        return (Long) getId();
    }
    @Override
    protected PlanExpense createInstance() {
        PlanExpense planExpense = new PlanExpense();
        return planExpense;
    }
    public void load() {
        if (isIdDefined()) {
            wire();
        }
    }
    public void wire() {
        getInstance();
        Activity activity = activityHome.getDefinedInstance();
        if (activity != null) {
            getInstance().setActivity(activity);
        }
    }
    public boolean isWired() {
        if (getInstance().getActivity() == null) return false;
        return true;
    }
    public PlanExpense getDefinedInstance() {
        return isIdDefined() ? getInstance() : null;
    }
    public List<PlanExpenseDetail> getPlanExpenseDetails() {
        return getInstance() == null ? null : new ArrayList<PlanExpenseDetail>(getInstance().getPlanExpenseDetails());
    }
}
