// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: BaseEntityHome.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.action.home;
import kuzumeji.entity.BaseEntity;
import kuzumeji.entity.ResourceEntity;
import kuzumeji.entity.TrackEntity;
import kuzumeji.entity.idm.User;
import kuzumeji.entity.sys.Notify;
import java.util.Date;
import javax.persistence.EntityManager;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.framework.EntityHome;
import org.jboss.seam.international.StatusMessage.Severity;
import org.jboss.seam.log.Log;
/**
 * BaseEntityQuery
 * @author nilcy
 * @param <E> Entity
 */
public class BaseEntityHome<E> extends EntityHome<E> {
    /** S/N */
    private static final long serialVersionUID = 2217798076779979786L;
    /** EntityManager */
    @In
    EntityManager em;
    /** Logger */
    @Logger
    private Log log;
    /** Login User */
    @In
    protected User loginUser;
    /**
     * @see org.jboss.seam.framework.EntityHome#create()
     */
    @Override
    public void create() {
        super.create();
        // if (getInstance() instanceof ContactMarker) {
        // ContactMarker cm = (ContactMarker) getInstance();
        // cm.setContact(new Contact());
        // }
    }
    /**
     * @see org.jboss.seam.framework.EntityHome#persist()
     */
    @Override
    public String persist() {
        if (getInstance() instanceof TrackEntity) {
            TrackEntity te = (TrackEntity) getInstance();
            te.setCreateUser(this.loginUser.getAccount());
            te.setCreateTime(new Date());
        }
        return super.persist();
    }
    /**
     * @see org.jboss.seam.framework.EntityHome#update()
     */
    @Override
    public String update() {
        if (getInstance() instanceof TrackEntity) {
            TrackEntity te = (TrackEntity) getInstance();
            te.setUpdateUser(this.loginUser.getAccount());
            te.setUpdateTime(new Date());
        }
        return super.update();
    }
    /**
     * @see org.jboss.seam.framework.EntityHome#remove()
     */
    @Override
    public String remove() {
        return super.remove();
    }
    /**
     * copy
     * @return msg
     */
    @SuppressWarnings("unchecked")
    public String copy() {
        if (!(getInstance() instanceof BaseEntity)) {
            getStatusMessages().add(Severity.ERROR, "copy failed.");
            return "copy_failed";
        }
        BaseEntity from = (BaseEntity) getInstance();
        E to = (E) from.clone();
        BaseEntity toBe = (BaseEntity) to;
        toBe.setId(null);
        toBe.setVerno(null);
        if (to instanceof TrackEntity) {
            TrackEntity toTe = (TrackEntity) to;
            toTe.setCreateTime(null);
            toTe.setCreateUser(null);
            toTe.setUpdateTime(null);
            toTe.setUpdateTime(null);
        }
        if (to instanceof ResourceEntity) {
            ResourceEntity toRe = (ResourceEntity) to;
            toRe.setCreatable(true);
            toRe.setReadable(true);
        }
        if (to instanceof Notify) {
            Notify toNotify = (Notify) to;
            toNotify.setTime(new Date());
            toNotify.setUser(this.loginUser.getWorker().getName());
        }
        clearInstance();
        setInstance(to);
        this.log.info("toInstance[#0], getInstance[#1]", to, getInstance());
        setId(null);
        return "copied";
    }
    /**
     * @see org.jboss.seam.framework.EntityHome#getEntityManager()
     */
    @Override
    public EntityManager getEntityManager() {
        return this.em;
    }
}
