/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.webservice;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Manager;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.servlet.ServletRequestSessionMap;
import org.jboss.seam.web.ServletContexts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPRequestHandler
implements SOAPHandler {
    public static final QName CIDQN = new QName("http://www.jboss.org/seam/webservice", "conversationId", "seam");
    private static final LogProvider log = Logging.getLogProvider(SOAPRequestHandler.class);
    private Set<QName> headers = new HashSet<QName>();
    private String handlerName;

    public boolean handleMessage(MessageContext msgContext) {
        Boolean outbound = (Boolean)msgContext.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outbound == null) {
            throw new IllegalStateException("Cannot obtain required property: javax.xml.ws.handler.message.outbound");
        }
        return outbound != false ? this.handleOutbound(msgContext) : this.handleInbound(msgContext);
    }

    public boolean handleInbound(MessageContext messageContext) {
        try {
            HttpServletRequest request = (HttpServletRequest)messageContext.get((Object)"javax.xml.ws.servlet.request");
            ServletLifecycle.beginRequest(request);
            ServletContexts.instance().setRequest(request);
            String conversationId = this.extractConversationId(messageContext);
            ConversationPropagation.instance().setConversationId(conversationId);
            Manager.instance().restoreConversation();
            ServletLifecycle.resumeConversation(request);
            return true;
        }
        catch (SOAPException ex) {
            log.error("Error handling inbound SOAP request", ex);
            return false;
        }
    }

    public boolean handleOutbound(MessageContext messageContext) {
        try {
            SOAPMessageContext smc;
            SOAPHeader header;
            HttpServletRequest request = (HttpServletRequest)messageContext.get((Object)"javax.xml.ws.servlet.request");
            String conversationId = Manager.instance().getCurrentConversationId();
            if (conversationId != null && (header = (smc = (SOAPMessageContext)messageContext).getMessage().getSOAPHeader()) != null) {
                SOAPElement element = header.addChildElement(CIDQN);
                element.addTextNode(conversationId);
                smc.getMessage().saveChanges();
            }
            Manager.instance().endRequest(new ServletRequestSessionMap(request));
            return true;
        }
        catch (SOAPException ex) {
            log.error("Exception processing outbound message", ex);
            return false;
        }
    }

    private String extractConversationId(MessageContext messageContext) throws SOAPException {
        Iterator iter;
        SOAPMessageContext smc = (SOAPMessageContext)messageContext;
        SOAPHeader header = smc.getMessage().getSOAPHeader();
        if (header != null && (iter = header.getChildElements(CIDQN)).hasNext()) {
            SOAPElement element = (SOAPElement)iter.next();
            return element.getFirstChild().getNodeValue();
        }
        return null;
    }

    public void close(MessageContext messageContext) {
        Lifecycle.endRequest();
    }

    public Set<QName> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Set<QName> headers) {
        this.headers = headers;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public void setHandlerName(String handlerName) {
        this.handlerName = handlerName;
    }

    public boolean handleFault(MessageContext messagecontext) {
        return true;
    }

    public String toString() {
        return this.handlerName != null ? this.handlerName : super.toString();
    }
}

