/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.security.Principal;
import java.security.acl.Group;
import javax.security.auth.Subject;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.SimpleGroup;
import org.jboss.seam.security.SimplePrincipal;

public abstract class RunAsOperation {
    private Principal principal = new SimplePrincipal(null);
    private Subject subject = new Subject();
    private boolean systemOp = false;

    public RunAsOperation() {
    }

    public RunAsOperation(boolean systemOp) {
        this();
        this.systemOp = systemOp;
    }

    public abstract void execute();

    public Principal getPrincipal() {
        return this.principal;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public RunAsOperation addRole(String role) {
        for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!"Roles".equals(sg.getName())) continue;
            sg.addMember((Principal)new SimplePrincipal(role));
            break;
        }
        SimpleGroup roleGroup = new SimpleGroup("Roles");
        roleGroup.addMember(new SimplePrincipal(role));
        this.getSubject().getPrincipals().add((Principal)((Object)roleGroup));
        return this;
    }

    public boolean isSystemOperation() {
        return this.systemOp;
    }

    public void run() {
        Identity.instance().runAs(this);
    }
}

