package filedrop;

import java.awt.BorderLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.JButton;
import javax.swing.JTextArea;

//import sample.DnDExam;

public class FileDropFrame extends JFrame {

	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JButton exitButton = null;
	private JTextArea jTextArea = null;

	public static void main(String[] args) {
		FileDropFrame frame = new FileDropFrame();
		frame.setVisible(true);
	}

	/**
	 * This is the default constructor
	 */
	public FileDropFrame() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 *
	 * @return void
	 */
	private void initialize() {
		this.setSize(300, 200);
		this.setContentPane(getJContentPane());
		this.setTitle("JFrame");
		// this.pack();

		new DropTarget(this, DnDConstants.ACTION_MOVE, new MyDropTargetAdapter(
				jTextArea), true);

		new DropTarget(jTextArea, new MyDropTargetAdapter(jTextArea));
		// new DropTarget(jTextArea, DnDConstants.ACTION_COPY,
		// new MyDropTargetListener(jTextArea), true);
	}

	/**
	 * This method initializes jContentPane
	 *
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getExitButton(), BorderLayout.SOUTH);
			jContentPane.add(getJTextArea(), BorderLayout.CENTER);
		}
		return jContentPane;
	}

	/**
	 * This method initializes exitButton
	 *
	 * @return javax.swing.JButton
	 */
	private JButton getExitButton() {
		if (exitButton == null) {
			exitButton = new JButton("終了");
			exitButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					System.exit(0);
				}
			});
		}
		return exitButton;
	}

	/**
	 * This method initializes jTextArea
	 *
	 * @return javax.swing.JTextArea
	 */
	private JTextArea getJTextArea() {
		if (jTextArea == null) {
			jTextArea = new JTextArea();
		}
		return jTextArea;
	}

	private class MyDropTargetAdapter extends DropTargetAdapter {
		private JTextArea textarea;

		public MyDropTargetAdapter(JTextArea textarea) {
			System.out.println("MyDropTargetAdapter");
			this.textarea = textarea;
		}

		public void drop(DropTargetDropEvent dtde) {
			System.out.println("MyDropTargetAdapter.drop");
			try {
				if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
					dtde.acceptDrop(DnDConstants.ACTION_COPY);
					Transferable transferable = dtde.getTransferable();
					List<File> list;
					list = (List<File>) transferable
							.getTransferData(DataFlavor.javaFileListFlavor);
					for (File file : list) {
						textarea.setText(file.toString() + "\n");
					}
					dtde.dropComplete(true);
				}
			} catch (UnsupportedFlavorException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
		}
	}

}
