package com.kurukurupapa.tryandroid.fw.apt;

import java.util.Set;

import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

/**
 * SQLite向けの簡単なO/Rマッパーです。APT（Annotation Processing Tool）で実現しています。
 *
 * 使い方<br />
 * １．プロジェクトのプロパティを開きます。<br/>
 * ２．Javaコンパイラ→注釈処理を開き、「プロジェクト固有の設定を可能にする」にチェックを入れます。<br/>
 * ３．Javaコンパイラ→注釈処理→ファクトリーパスを開き、「プロジェクト固有の設定を可能にする」にチェックを入れます。<br/>
 * ４．さらに、「Jar追加」ボタンを押して、次のJarを追加します。<br/>
 * ・tryandroidapt.jar<br/>
 * ・commons-collections-xxx.jar<br/>
 * ・log4j-xxx.jar<br/>
 * ・log4j-core-xxx.jar<br/>
 * ・velocity-xxx.jar<br/>
 * ・s2util-xxx.jar<br/>
 */
@SupportedSourceVersion(SourceVersion.RELEASE_6)
@SupportedAnnotationTypes({ "com.kurukurupapa.tryandroid.fw.apt.TaaEntity" })
public class TryAndroidFwProcesser extends AbstractProcessor {

	@Override
	public boolean process(Set<? extends TypeElement> annotations,
			RoundEnvironment roundEnv) {
		// 引数チェック
		if (annotations.isEmpty()) {
			return true;
		}

		// ソース生成
		TypeElement annotation = annotations.iterator().next();
		DaoGenerater daoGenerator = new DaoGenerater();
		for (Element element : roundEnv.getElementsAnnotatedWith(annotation)) {
			daoGenerator.generateSource(element, processingEnv);
		}
		return true;
	}

}
