package com.kurukurupapa.tryandroid.fw;

import java.util.HashMap;

/**
 * ListAdapter用マップデータ
 *
 * ListViewではListAdapter経由でリスト表示のデータにアクセスする。
 * 当クラスでは、ListAdapterでアクセス可能な形式のデータを保持する。
 */
public class MapForListAdapter extends HashMap<String, Object> {
	/**
	 * デフォルトシリアルバージョンID
	 */
	private static final long serialVersionUID = 1L;

	public static final String KEY_TEXT1 = "text1";
	public static final String KEY_TEXT2 = "text2";

	public String getText1() {
		return (String) get(KEY_TEXT1);
	}

	public void setText1(String text) {
		put(KEY_TEXT1, text);
	}

	public String getText2() {
		return (String) get(KEY_TEXT2);
	}

	public void setText2(String text) {
		put(KEY_TEXT2, text);
	}
}
