package com.kurukurupapa.tryandroid.fw;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.widget.EditText;

/**
 * EditViewを1つ持つダイアログ
 */
public class AlertDialogWithEditView extends AlertDialog {

	private EditText editText;

	public AlertDialogWithEditView(Context context, String title,
			String defaultText) {
		this(context, title, defaultText, null, null);
	}

	public AlertDialogWithEditView(Context context, String title,
			String defaultText, DialogInterface.OnClickListener okListener) {
		this(context, title, defaultText, okListener, null);
	}

	public AlertDialogWithEditView(Context context, String title,
			String defaultText, DialogInterface.OnClickListener okListener,
			DialogInterface.OnClickListener cancelListener) {
		super(context);

		editText = new EditText(context);
		editText.setText(defaultText);

		setTitle(title);
		setButton(BUTTON_POSITIVE, context.getString(android.R.string.ok),
				okListener);
		setButton(BUTTON_NEGATIVE, context.getString(android.R.string.cancel),
				cancelListener);
		setView(editText);
	}

	public String getInputText() {
		return editText.getText().toString();
	}

}
