package com.kurukurupapa.tryandroiddb.performance;

import com.kurukurupapa.tryandroid.fw.util.LogUtil;
import com.kurukurupapa.tryandroiddb.R;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

public class PerformanceActivity extends Activity {
	private Button startButton;
	private Button stopButton;
	private TextView textView;
	private PerformanceTask task;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		LogUtil.called();

		super.onCreate(savedInstanceState);
		setContentView(R.layout.performance_activity);

		startButton = (Button) findViewById(R.id.start_button);
		stopButton = (Button) findViewById(R.id.stop_button);
		textView = (TextView) findViewById(R.id.db_text_view);

		task = new PerformanceTask(this, textView);

		startButton.setEnabled(true);
		stopButton.setEnabled(false);
	}

	public void onClickStartButton(View view) {
		LogUtil.called();

		try {
			startButton.setEnabled(false);
			stopButton.setEnabled(true);

			task.execute(new Void[] {});
		} catch (Exception e) {
			LogUtil.e("Error", e);
		}
	}

	public void onClickStopButton(View view) {
		LogUtil.called();

		try {
			task.cancel(true);
		} catch (Exception e) {
			LogUtil.e("Error", e);
		}
	}

}
