/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.seasar.util.exception.IORuntimeException;
import org.seasar.util.io.FileUtil;
import org.seasar.util.log.Logger;
import org.seasar.util.misc.AssertionUtil;
import org.seasar.util.net.URLUtil;

public abstract class ZipFileUtil {
    private static final Logger logger = Logger.getLogger(ZipFileUtil.class);

    public static ZipFile create(String file) {
        AssertionUtil.assertArgumentNotEmpty("file", file);
        try {
            return new ZipFile(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ZipFile create(File file) {
        AssertionUtil.assertArgumentNotNull("file", file);
        try {
            return new ZipFile(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static InputStream getInputStream(ZipFile file, ZipEntry entry) {
        AssertionUtil.assertArgumentNotNull("file", file);
        AssertionUtil.assertArgumentNotNull("entry", entry);
        try {
            return file.getInputStream(entry);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ZipFile toZipFile(URL zipUrl) {
        AssertionUtil.assertArgumentNotNull("zipUrl", zipUrl);
        return ZipFileUtil.create(new File(ZipFileUtil.toZipFilePath(zipUrl)));
    }

    public static String toZipFilePath(URL zipUrl) {
        AssertionUtil.assertArgumentNotNull("zipUrl", zipUrl);
        String urlString = zipUrl.getPath();
        int pos = urlString.lastIndexOf(33);
        String zipFilePath = urlString.substring(0, pos);
        File zipFile = new File(URLUtil.decode(zipFilePath, "UTF8"));
        return FileUtil.getCanonicalPath(zipFile);
    }

    public static void close(ZipFile zipFile) {
        AssertionUtil.assertArgumentNotNull("zipFile", zipFile);
        try {
            zipFile.close();
        }
        catch (IOException e) {
            logger.log(Logger.format("EUTL0017", e.getMessage()), e);
        }
    }
}

