/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import java.util.List;
import org.seasar.doma.internal.jdbc.sql.CallableSqlParameterVisitor;
import org.seasar.doma.internal.jdbc.sql.ListParameter;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.EntityType;

public class EntityListParameter<E>
implements ListParameter<EntityType<E>, E> {
    protected final List<E> entities;
    protected final EntityType<E> entityType;
    protected final String name;

    public EntityListParameter(EntityType<E> entityType, List<E> entities, String name) {
        AssertionUtil.assertNotNull(entityType, entities, (Object)name);
        this.entityType = entityType;
        this.entities = entities;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return this.entities;
    }

    public EntityType<E> getEntityType() {
        return this.entityType;
    }

    @Override
    public void add(E entity) {
        this.entities.add(entity);
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CallableSqlParameterVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitEntityListParameter(this, p);
    }
}

