/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.util.HashMap;
import java.util.Map;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.Value;
import org.seasar.doma.internal.jdbc.command.BasicSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.SelectCommand;
import org.seasar.doma.internal.jdbc.query.CountQuery;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SelectOptions;
import org.seasar.doma.jdbc.SelectOptionsAccessor;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.wrapper.LongWrapper;

public class SqlSelectQuery
implements SelectQuery {
    protected Config config;
    protected final Map<String, Value> parameters = new HashMap<String, Value>();
    protected String callerClassName;
    protected String callerMethodName;
    protected SqlNode sqlNode;
    protected PreparedSql sql;
    protected SelectOptions options = SelectOptions.get();
    protected boolean resultEnsured;
    protected int fetchSize;
    protected int maxRows;
    protected int queryTimeout;

    @Override
    public void prepare() {
        AssertionUtil.assertNotNull((Object)this.config, (Object)this.sqlNode, (Object)this.callerClassName, (Object)this.callerMethodName);
        this.prepareOptions();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void prepareOptions() {
        if (this.fetchSize <= 0) {
            this.fetchSize = this.config.getFetchSize();
        }
        if (this.maxRows <= 0) {
            this.maxRows = this.config.getMaxRows();
        }
        if (this.queryTimeout <= 0) {
            this.queryTimeout = this.config.getQueryTimeout();
        }
    }

    protected void prepareSql() {
        SqlNode transformedSqlNode = this.config.getDialect().transformSelectSqlNode(this.sqlNode, this.options);
        ExpressionEvaluator evaluator = new ExpressionEvaluator(this.parameters, this.config.getDialect().getExpressionFunctions());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder(this.config, SqlKind.SELECT, null, evaluator);
        this.sql = sqlBuilder.build(transformedSqlNode);
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public SelectOptions getOptions() {
        return this.options;
    }

    @Override
    public PreparedSql getSql() {
        return this.sql;
    }

    @Override
    public boolean isResultEnsured() {
        return this.resultEnsured;
    }

    @Override
    public void complete() {
        if (!SelectOptionsAccessor.isCount(this.options)) {
            return;
        }
        CountQuery query = new CountQuery();
        query.callerClassName = this.callerClassName;
        query.callerMethodName = this.callerMethodName;
        query.config = this.config;
        query.fetchSize = this.fetchSize;
        query.maxRows = this.maxRows;
        query.options = this.options;
        query.parameters = this.parameters;
        query.queryTimeout = this.queryTimeout;
        query.sqlNode = this.sqlNode;
        query.prepare();
        SelectCommand<Long> command = new SelectCommand<Long>(query, new BasicSingleResultHandler<Long>(new LongWrapper(), true));
        long count = command.execute();
        query.complete();
        SelectOptionsAccessor.setCountSize(this.options, count);
    }

    @Override
    public String getClassName() {
        return this.callerClassName;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public String getMethodName() {
        return this.callerMethodName;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setOptions(SelectOptions options) {
        this.options = options;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setSqlNode(SqlNode sqlNode) {
        this.sqlNode = sqlNode;
    }

    public void addParameter(String name, Class<?> type, Object value) {
        AssertionUtil.assertNotNull((Object)name, type);
        this.parameters.put(name, new Value(type, value));
    }

    public void setCallerClassName(String callerClassName) {
        this.callerClassName = callerClassName;
    }

    public void setCallerMethodName(String callerMethodName) {
        this.callerMethodName = callerMethodName;
    }

    public void setResultEnsured(boolean resultEnsured) {
        this.resultEnsured = resultEnsured;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public String toString() {
        return this.sql != null ? this.sql.toString() : null;
    }
}

