/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.sql.Statement;
import org.seasar.doma.internal.jdbc.entity.AbstractPostInsertContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreInsertContext;
import org.seasar.doma.internal.jdbc.query.InsertQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileModifyQuery;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityType;

public class SqlFileInsertQuery
extends SqlFileModifyQuery
implements InsertQuery {
    protected EntityHandler<?> entityHandler;

    public SqlFileInsertQuery() {
        super(SqlKind.INSERT);
    }

    @Override
    public void prepare() {
        AssertionUtil.assertNotNull((Object)this.config, (Object)this.sqlFilePath, (Object)this.callerClassName, (Object)this.callerMethodName);
        this.preInsert();
        this.prepareOptions();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void preInsert() {
        if (this.entityHandler != null) {
            this.entityHandler.preInsert();
        }
    }

    @Override
    public void generateId(Statement statement) {
    }

    @Override
    public void complete() {
        if (this.entityHandler != null) {
            this.entityHandler.postInsert();
        }
    }

    @Override
    public <E> void setEntityAndEntityType(E entity, EntityType<E> entityType) {
        this.entityHandler = new EntityHandler<E>(entity, entityType);
    }

    protected static class SqlFilePostInsertContext
    extends AbstractPostInsertContext {
        public SqlFilePostInsertContext(EntityType<?> entityType) {
            super(entityType);
        }
    }

    protected static class SqlFilePreInsertContext
    extends AbstractPreInsertContext {
        public SqlFilePreInsertContext(EntityType<?> entityType) {
            super(entityType);
        }
    }

    protected class EntityHandler<E> {
        protected E entity;
        protected EntityType<E> entityType;

        protected EntityHandler(E entity, EntityType<E> entityType) {
            AssertionUtil.assertNotNull(entity, entityType);
            this.entity = entity;
            this.entityType = entityType;
        }

        protected void preInsert() {
            SqlFilePreInsertContext context = new SqlFilePreInsertContext(this.entityType);
            this.entityType.preInsert(this.entity, context);
        }

        protected void postInsert() {
            SqlFilePostInsertContext context = new SqlFilePostInsertContext(this.entityType);
            this.entityType.postInsert(this.entity, context);
        }
    }
}

