/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.sql.Statement;
import java.util.Iterator;
import org.seasar.doma.internal.jdbc.entity.AbstractPostInsertContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreInsertContext;
import org.seasar.doma.internal.jdbc.query.BatchInsertQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileBatchModifyQuery;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityType;

public class SqlFileBatchInsertQuery<E>
extends SqlFileBatchModifyQuery<E>
implements BatchInsertQuery {
    protected EntityHandler entityHandler;

    public SqlFileBatchInsertQuery(Class<E> elementClass) {
        super(elementClass, SqlKind.BATCH_INSERT);
    }

    @Override
    public void prepare() {
        super.prepare();
        Iterator it = this.elements.iterator();
        if (it.hasNext()) {
            this.executable = true;
            this.sqlExecutionSkipCause = null;
            this.currentEntity = it.next();
            this.preInsert();
            this.prepareSqlFile();
            this.prepareOptions();
            this.prepareSql();
        } else {
            return;
        }
        while (it.hasNext()) {
            this.currentEntity = it.next();
            this.preInsert();
            this.prepareSql();
        }
        AssertionUtil.assertEquals(this.elements.size(), this.sqls.size());
    }

    protected void preInsert() {
        if (this.entityHandler != null) {
            this.entityHandler.preInsert();
        }
    }

    @Override
    public void generateId(Statement statement, int index) {
    }

    @Override
    public void complete() {
        if (this.entityHandler != null) {
            for (Object element : this.elements) {
                this.currentEntity = element;
                this.entityHandler.postInsert();
            }
        }
    }

    @Override
    public void setEntityType(EntityType<E> entityType) {
        this.entityHandler = new EntityHandler(entityType);
    }

    @Override
    public boolean isBatchSupported() {
        return true;
    }

    protected static class SqlFileBatchPostInsertContext
    extends AbstractPostInsertContext {
        public SqlFileBatchPostInsertContext(EntityType<?> entityType) {
            super(entityType);
        }
    }

    protected static class SqlFileBatchPreInsertContext
    extends AbstractPreInsertContext {
        public SqlFileBatchPreInsertContext(EntityType<?> entityType) {
            super(entityType);
        }
    }

    protected class EntityHandler {
        protected EntityType<E> entityType;

        protected EntityHandler(EntityType<E> entityType) {
            AssertionUtil.assertNotNull(entityType);
            this.entityType = entityType;
        }

        protected void preInsert() {
            SqlFileBatchPreInsertContext context = new SqlFileBatchPreInsertContext(this.entityType);
            this.entityType.preInsert(SqlFileBatchInsertQuery.this.currentEntity, context);
        }

        protected void postInsert() {
            SqlFileBatchPostInsertContext context = new SqlFileBatchPostInsertContext(this.entityType);
            this.entityType.postInsert(SqlFileBatchInsertQuery.this.currentEntity, context);
        }
    }
}

