/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.util.ArrayList;
import java.util.Iterator;
import org.seasar.doma.internal.jdbc.entity.AbstractPostUpdateContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreUpdateContext;
import org.seasar.doma.internal.jdbc.query.AutoBatchModifyQuery;
import org.seasar.doma.internal.jdbc.query.BatchUpdateQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;

public class AutoBatchUpdateQuery<E>
extends AutoBatchModifyQuery<E>
implements BatchUpdateQuery {
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public AutoBatchUpdateQuery(EntityType<E> entityType) {
        super(entityType);
    }

    @Override
    public void prepare() {
        AssertionUtil.assertNotNull((Object)this.config, (Object)this.callerClassName, (Object)this.callerMethodName, (Object)this.entities, (Object)this.sqls);
        Iterator it = this.entities.iterator();
        if (it.hasNext()) {
            this.executable = true;
            this.executionSkipCause = null;
            this.currentEntity = it.next();
            this.preUpdate();
            this.prepareIdAndVersionPropertyTypes();
            this.validateIdExistent();
            this.prepareOptions();
            this.prepareOptimisticLock();
            this.prepareTargetPropertyTypes();
            this.prepareSql();
        } else {
            return;
        }
        while (it.hasNext()) {
            this.currentEntity = it.next();
            this.preUpdate();
            this.prepareSql();
        }
        AssertionUtil.assertEquals(this.entities.size(), this.sqls.size());
    }

    protected void preUpdate() {
        AutoBatchPreUpdateContext context = new AutoBatchPreUpdateContext(this.entityType);
        this.entityType.preUpdate(this.currentEntity, context);
    }

    protected void prepareOptimisticLock() {
        if (this.versionPropertyType != null && !this.versionIgnored && !this.optimisticLockExceptionSuppressed) {
            this.optimisticLockCheckRequired = true;
        }
    }

    protected void prepareTargetPropertyTypes() {
        this.targetPropertyTypes = new ArrayList(this.entityType.getEntityPropertyTypes().size());
        for (EntityPropertyType p : this.entityType.getEntityPropertyTypes()) {
            if (!p.isUpdatable() || p.isId()) continue;
            if (p.isVersion()) {
                this.targetPropertyTypes.add(p);
                continue;
            }
            if (!this.isTargetPropertyName(p.getName())) continue;
            this.targetPropertyTypes.add(p);
        }
    }

    protected void prepareSql() {
        PreparedSqlBuilder builder = new PreparedSqlBuilder(this.config, SqlKind.BATCH_UPDATE);
        builder.appendSql("update ");
        builder.appendSql(this.entityType.getQualifiedTableName());
        builder.appendSql(" set ");
        for (EntityPropertyType p : this.targetPropertyTypes) {
            builder.appendSql(p.getColumnName());
            builder.appendSql(" = ");
            builder.appendWrapper(p.getWrapper(this.currentEntity));
            if (p.isVersion() && !this.versionIgnored) {
                builder.appendSql(" + 1");
            }
            builder.appendSql(", ");
        }
        builder.cutBackSql(2);
        if (this.idPropertyTypes.size() > 0) {
            builder.appendSql(" where ");
            for (EntityPropertyType p : this.idPropertyTypes) {
                builder.appendSql(p.getColumnName());
                builder.appendSql(" = ");
                builder.appendWrapper(p.getWrapper(this.currentEntity));
                builder.appendSql(" and ");
            }
            builder.cutBackSql(5);
        }
        if (this.versionPropertyType != null && !this.versionIgnored) {
            if (this.idPropertyTypes.size() == 0) {
                builder.appendSql(" where ");
            } else {
                builder.appendSql(" and ");
            }
            builder.appendSql(this.versionPropertyType.getColumnName());
            builder.appendSql(" = ");
            builder.appendWrapper(this.versionPropertyType.getWrapper(this.currentEntity));
        }
        PreparedSql sql = builder.build();
        this.sqls.add(sql);
    }

    @Override
    public void incrementVersions() {
        if (this.versionPropertyType != null && !this.versionIgnored) {
            for (Object entity : this.entities) {
                this.versionPropertyType.increment(entity);
            }
        }
    }

    @Override
    public void complete() {
        for (Object entity : this.entities) {
            this.currentEntity = entity;
            this.postUpdate();
        }
    }

    protected void postUpdate() {
        AutoBatchPostUpdateContext context = new AutoBatchPostUpdateContext(this.entityType);
        this.entityType.postUpdate(this.currentEntity, context);
    }

    public void setVersionIncluded(boolean versionIncluded) {
        this.versionIgnored |= versionIncluded;
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored |= versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected static class AutoBatchPostUpdateContext
    extends AbstractPostUpdateContext {
        public AutoBatchPostUpdateContext(EntityType<?> entityType) {
            super(entityType);
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }

    protected static class AutoBatchPreUpdateContext
    extends AbstractPreUpdateContext {
        public AutoBatchPreUpdateContext(EntityType<?> entityType) {
            super(entityType);
        }

        @Override
        public boolean isEntityChanged() {
            return true;
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }
}

