/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.util.Iterator;
import org.seasar.doma.internal.jdbc.entity.AbstractPostDeleteContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreDeleteContext;
import org.seasar.doma.internal.jdbc.query.AutoBatchModifyQuery;
import org.seasar.doma.internal.jdbc.query.BatchDeleteQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;

public class AutoBatchDeleteQuery<E>
extends AutoBatchModifyQuery<E>
implements BatchDeleteQuery {
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public AutoBatchDeleteQuery(EntityType<E> entityType) {
        super(entityType);
    }

    @Override
    public void prepare() {
        AssertionUtil.assertNotNull((Object)this.config, (Object)this.callerClassName, (Object)this.callerMethodName, (Object)this.entities, (Object)this.sqls);
        Iterator it = this.entities.iterator();
        if (it.hasNext()) {
            this.executable = true;
            this.executionSkipCause = null;
            this.currentEntity = it.next();
            this.preDelete();
            this.prepareIdAndVersionPropertyTypes();
            this.validateIdExistent();
            this.prepareOptions();
            this.prepareOptimisticLock();
            this.prepareSql();
        } else {
            return;
        }
        while (it.hasNext()) {
            this.currentEntity = it.next();
            this.preDelete();
            this.prepareSql();
        }
        AssertionUtil.assertEquals(this.entities.size(), this.sqls.size());
    }

    protected void preDelete() {
        AutoBatchPreDeleteContext context = new AutoBatchPreDeleteContext(this.entityType);
        this.entityType.preDelete(this.currentEntity, context);
    }

    protected void prepareOptimisticLock() {
        if (this.versionPropertyType != null && !this.versionIgnored && !this.optimisticLockExceptionSuppressed) {
            this.optimisticLockCheckRequired = true;
        }
    }

    protected void prepareSql() {
        PreparedSqlBuilder builder = new PreparedSqlBuilder(this.config, SqlKind.BATCH_DELETE);
        builder.appendSql("delete from ");
        builder.appendSql(this.entityType.getQualifiedTableName());
        if (this.idPropertyTypes.size() > 0) {
            builder.appendSql(" where ");
            for (EntityPropertyType p : this.idPropertyTypes) {
                builder.appendSql(p.getColumnName());
                builder.appendSql(" = ");
                builder.appendWrapper(p.getWrapper(this.currentEntity));
                builder.appendSql(" and ");
            }
            builder.cutBackSql(5);
        }
        if (this.versionPropertyType != null && !this.versionIgnored) {
            if (this.idPropertyTypes.size() == 0) {
                builder.appendSql(" where ");
            } else {
                builder.appendSql(" and ");
            }
            builder.appendSql(this.versionPropertyType.getColumnName());
            builder.appendSql(" = ");
            builder.appendWrapper(this.versionPropertyType.getWrapper(this.currentEntity));
        }
        PreparedSql sql = builder.build();
        this.sqls.add(sql);
    }

    @Override
    public void complete() {
        for (Object entity : this.entities) {
            this.currentEntity = entity;
            this.postDelete();
        }
    }

    protected void postDelete() {
        AutoBatchPostDeleteContext context = new AutoBatchPostDeleteContext(this.entityType);
        this.entityType.postDelete(this.currentEntity, context);
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored = versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected static class AutoBatchPostDeleteContext
    extends AbstractPostDeleteContext {
        public AutoBatchPostDeleteContext(EntityType<?> entityType) {
            super(entityType);
        }
    }

    protected static class AutoBatchPreDeleteContext
    extends AbstractPreDeleteContext {
        public AutoBatchPreDeleteContext(EntityType<?> entityType) {
            super(entityType);
        }
    }
}

